/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.ui.wizard

import com.google.inject.Inject
import com.yakindu.sctunit.sCTUnit.SCTUnitElement
import java.util.List
import org.eclipse.xtext.conversion.IValueConverterService
import com.yakindu.sct.model.sgraph.Statechart

import static com.yakindu.base.expressions.terminals.ExpressionsValueConverterService.QID;
import com.yakindu.sct.generator.core.extensions.StringHelper

/** 
 * @author jonathan thoene - Initial contribution and API 
 */
class SCTUnitModelCreator {

	@Inject
	IValueConverterService converter
	
	@Inject extension StringHelper

	def createInitialModel(String fileName, Statechart statechart) {
		val name = statechart.namespace.dot(statechart.name)
		'''
			testclass «converter.toString(fileName.replaceAll(".sctunit",""), "ID")» for statechart «converter.toString(name, QID)» {
				
				«testbody»
			}
		'''
	}

	def createInitialModel(String fileName) {
		'''
			testclass «converter.toString(fileName.replaceAll(".sctunit",""), "ID")» for statechart Statechart {
				
				«testbody»
			}
		'''
	}

	def testbody() {
		'''
			@Test
			operation test() {
				enter
				
				exit
			}
		'''
	}
	
	def createInitialSuite(String fileName, List<SCTUnitElement> testClasses){
		'''
			testsuite «converter.toString(fileName.replaceAll(".sctunit",""), "ID")» {
				«FOR testClass:testClasses SEPARATOR ','»
					«converter.toString(testClass.name, QID)»
				«ENDFOR»
			}
		'''
	}
	
	def createInitialSuite(String fileName){
		'''
			testsuite «converter.toString(fileName.replaceAll(".sctunit",""), "ID")» {
				
			}
		'''
	}
}
