/**
 * Copyright (c) 2016 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Robert Rudi - itemis AG
 *  Robin Herrmann - itemis AG
 * 
 */

package com.yakindu.sctunit.generator.scxml.qt.files

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite
import org.eclipse.xtext.generator.IFileSystemAccess
import com.yakindu.sct.model.sgen.GeneratorEntry

class ProjectFile {
	@Inject extension BaseNavigationExtensions
	@Inject extension BaseNamingExtensions

	def generate(GeneratorEntry entry, IFileSystemAccess fsa) {
		fsa.generateFile(filename(entry), content(entry))
	}

	def String filename(GeneratorEntry entry) {
		return "QtSCTUnit/SCTUnitTests.pro"
	}

	def String content(GeneratorEntry entry) {
		val headerFiles = getFiles(entry, "h")
		val sourceFiles = getFiles(entry, "cpp")
		'''
			QT       += core widgets testlib scxml
			
			QT       -= gui
			
			TARGET = qtsctunittests
			CONFIG   += console
			CONFIG   -= app_bundle
			
			TEMPLATE = app
			
			# The following define makes your compiler emit warnings if you use
			# any feature of Qt which has been marked as deprecated (the exact warnings
			# depend on your compiler). Please consult the documentation of the
			# deprecated API in order to know how to port your code away from it.
			DEFINES += QT_DEPRECATED_WARNINGS
			
			# You can also make your code fail to compile if you use deprecated APIs.
			# In order to do so, uncomment the following line.
			# You can also select to disable deprecated APIs only up to a certain version of Qt.
			#DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000    # disables all the APIs deprecated before Qt 6.0.0
			
			HEADERS += \
				src/abstractqtunittest.h«IF headerFiles !== null» \ 
				«FOR file : headerFiles SEPARATOR '\\'»
					«file»
				«ENDFOR»«ENDIF»
			
			SOURCES += \
			    src/abstractqtunittest.cpp \
			    src/testrunner.cpp«IF sourceFiles !== null» \
			    «FOR file : sourceFiles SEPARATOR '\\'»
			    	«file»
			    «ENDFOR»«ENDIF»
			
			STATECHARTS += $$files(../*.scxml, true) \
			
		'''
	}
	
    def getFiles(GeneratorEntry entry, String fileEnding) {
        val it = entry.SCTUnitElement
        
        switch (it) {
            SCTUnitClass: #[getFile(fileEnding)]
            SCTUnitSuite: getFile(fileEnding)
        }
    }
    
    def getFile(SCTUnitClass it, String fileEnding) {
        '''src/«testClassName.toLowerCase».«fileEnding»'''
    }
    
    def getFile(SCTUnitSuite it, String fileEnding){
        val files = newArrayList
        for(cls : SCTUnitClasses) {
            files += getFile(cls, fileEnding)
        }
        
        files
    }

}
