package com.yakindu.sctunit.concepts

import com.yakindu.base.types.libraries.AbstractTypeLibrary
import org.eclipse.emf.common.util.URI
import com.yakindu.base.types.AnnotationType
import com.yakindu.base.types.TypesPackage
import com.yakindu.base.types.libraries.ITypeLibraryProvider
import com.google.inject.Inject
import com.google.inject.Injector

class SCTUnitAnnotations {
	
	static class Library extends AbstractTypeLibrary {
		
		public static val LIBRARY = "create.sctunit"
		public static val LIBRARY_URI = URI.createURI(LIBRARY)

		public static val ROOT_PACKAGE_NAME = "sctunit"
		
		public static val TEST_ANNOTATION = "Test"
		public static val IGNORE_ANNOTATION = "Ignore"

		protected extension TypesPackage typesPackage = TypesPackage.eINSTANCE
		
		override protected createLibraryPackage() {
		ROOT_PACKAGE_NAME._package  => [ package |
			package.member.addAll( #[
				TEST_ANNOTATION._annotationType => [
					testTargets
				],
				IGNORE_ANNOTATION._annotationType => [
					testTargets
				]
			])
		]
		}
		
		def protected testTargets(AnnotationType it) {
		targets += #[ operation ]
	}
		
		override getLibraryURI() {
			LIBRARY_URI
		}

		static class Provider implements ITypeLibraryProvider {
			@Inject Injector injector
			override provide() {
				#[ injector.getInstance(SCTUnitAnnotations.Library) ]
			}
		}
		
	}
}