/**
* Copyright (c) 2025 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Axel Terfloth - itemis AG
*
*/
package com.yakindu.sct.model.stext

import com.google.inject.Inject
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.StextFactory

/**
 * Builder extension for building stext concepts.
 * 
 * @author axel terfloth
 */
class STextBuilder {
	
	@Inject extension TypeBuilder
	
	extension StextFactory factory = StextFactory.eINSTANCE
	
	def _interface(Statechart it) {
		var scope = createInterfaceScope
		scopes += scope
		scope
	}
	
	def _interface(Statechart it, String name) {
		var scope = createInterfaceScope
		scope.name = name
		scopes += scope
		scope
	}
	
	def _internal(Statechart it) {
		var scope = createInternalScope
		scopes += scope
		scope
	}
	
	def _scope(State it) {
		var scope = createSimpleScope
		scopes += scope
		scope
	}
	
	def _vardef(Scope scope, String name, Type type) {
		createVariableDefinition => [
			scope.declarations += it
			it.name = name
			it.typeSpecifier = type._typeSpecifier
		]
	}
}