/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.concepts

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ReactionTrigger
import com.yakindu.base.types.Trigger
import com.yakindu.sct.model.sgraph.Entry
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.Synchronization
import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.stext.stext.EntryPointSpec

/**
 * This class defines the general concept of completion transitions. 
 * 
 * @author lkovacs
 */
class CompletionTransition {
	
	@Inject extension ExitTransition
	
	def boolean isCompletionTransition(Transition it) {
		!exitTransition && noTriggerBehaviour && !forkTransition && !(source instanceof Entry)
	}
	
	def dispatch boolean hasCompletionTransition(RegularState state) {
		state.outgoingTransitions.exists[isCompletionTransition]
	}

	def dispatch boolean hasCompletionTransition(Statechart it) {
		eAllContents.filter(typeof(State)).exists[hasCompletionTransition]		
	}

	def Transition completionTransition(Iterable<Transition> transitions) {
		for (transition : transitions) {
			if(transition.completionTransition) return transition
		}
	}
	
	def protected dispatch boolean noTriggerBehaviour(Transition transition){
		transition.trigger.noTriggerBehaviour && (transition.properties.size == 0 || (transition.properties.size == 1 && transition.properties.get(0) instanceof EntryPointSpec))
	}
		
	def protected dispatch noTriggerBehaviour(Trigger trigger){
		false
	}
	
	def protected dispatch noTriggerBehaviour(ReactionTrigger trigger){
		trigger.triggers.size == 0 && trigger.guard === null
	}
	
	def protected dispatch noTriggerBehaviour(Void trigger){
		true
	}
	
	def protected forkTransition(Transition it){
		//Transition from Fork
		if((source instanceof Synchronization))
			return true
		false
	}
		
}