/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.concepts

import com.google.inject.Inject
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.util.SubchartDFS
import com.yakindu.sct.model.stext.extensions.STextExtensions
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.ArrayList
import java.util.List
import java.util.Stack
import org.eclipse.emf.ecore.util.EcoreUtil
import com.yakindu.base.types.TypesUtil

/**
 * Implements a multi statechart traversal starting with a root statechart. 
 * It calculates all referenced statecharts and statechart instance paths according to a DFS traversal.
 * This calculation is the basis for setting up multi statechart scenarios in sctunit tests and the simulation.
 *
 * Client can simply access the result via the getters after invoking perform(). 
 * The implementation is stateful. A call to perform will discard the previous state. 
 * Subclasses may overwrite the build hooks to take action during traversal.  
 * 
 * @author Axel Terfloth
 */
class SubchartTraversal extends SubchartDFS {

	@Inject protected extension STextExtensions
	@Inject protected extension TypesUtil

	protected Statechart root
	public var Stack<VariableDefinition> variableStack = null
	protected List<Statechart> subcharts = null
	protected List<InstancePath<VariableDefinition, Statechart>> subchartPaths = null
	
	def protected setUp() {}
	
	override synchronized perform(Object root) {
		if(root instanceof Statechart) this.root = root
		variableStack = new Stack
		subcharts = new ArrayList
		subchartPaths = new ArrayList
		setUp
		super.perform(root)
	}
	
	def protected void build(Statechart subchart, VariableDefinition element) {
	}
	
	def protected void build(InstancePath<VariableDefinition, Statechart> subchartPath) {
		build(subchartPath.type, subchartPath.path.lastOrNull)
	}
	
	override beginVisit(Object element, Object parent, int depth) {
		if (element instanceof VariableDefinition) {
			val subchart = getStatechart(element)
			if (!EcoreUtil.equals(subchart, root) && !element.isInternal) {
				variableStack.push(element)
				val subchartPath = new InstancePath(variableStack.listIterator.toList, subchart)
				subchartPaths += subchartPath
				if (!subcharts.contains(subchart)) subcharts += subchart
				build(subchartPath)				
			}
		}
	}
	
	override void endVisit(Object element, Object parent, int depth, int minDepth) {
		if (element instanceof VariableDefinition) {
			val subchart = getStatechart(element)
			if (!EcoreUtil.equals(subchart, root) && !element.isInternal) {
				variableStack.pop
			}
		}
	}
	
	def Statechart getRoot() {
		return root
	}
	
	def getSubchartTypes(Statechart it) {
		subcharts ?: {
			perform
			subcharts
		}
	}
	
	def getSubchartPaths(Statechart it) {
		subchartPaths ?: {
			perform
			subchartPaths
		}
	}	
	
}