/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * Jonathan Thoene - itemis AG
 */
package com.yakindu.sctunit.generator.java.extensions

import com.google.inject.Inject
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sctunit.generator.base.extensions.BaseStatementExtensions
import com.yakindu.sctunit.sCTUnit.AssertionStatement
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * @author jonathan thoene - Adding of templates to generate mocking statements
 * 
 */
class JavaStatementExtensions extends BaseStatementExtensions {

	@Inject	extension JavaExpressionExtensions
	@Inject extension ICodegenTypeSystemAccess
	@Inject	extension IMockingExtensions
	@Inject extension StatechartAnnotations

	def dispatch CharSequence generate(AssertionStatement stm) {
		'''
			assertTrue(«IF !stm.errorMsg.nullOrEmpty»"«stm.errorMsg»",«ENDIF»«stm.expression.code»);
		'''
	}

	override dispatch CharSequence generate(VariableDefinitionStatement stm) {
		if (stm.definition.initialValue !== null) {
			'''«stm.definition.type.targetLanguageName» «stm.definition.name» = «stm.definition.initialValue.code»;'''
		} else {
			'''«stm.definition.type.targetLanguageName» «stm.definition.name»;'''
		}
	}

	def dispatch CharSequence generate(VerifyCalledStatement it) {
		if (!negated) {
			generatePositiveVerify
		} else {
			generateNegativeVerify
		}
	}

	def dispatch CharSequence generate(MockReturnStatement it) {
		generateMockReturn
	}

	def getCyclePeriod(SCTUnitClass it) {
		statechart.cyclePeriod
	}
}
