/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.java.extensions

import com.google.inject.Inject
import com.yakindu.base.types.Parameter
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sctunit.generator.base.extensions.BaseMockingExtensions
import com.yakindu.sctunit.generator.java.features.JavaSCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.TestStatement
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement
import java.util.List

/**
 * 
 * @author jonathan thoene - Initial contribution and API
 * 
 */
class MockitoExtensions extends BaseMockingExtensions implements IMockingExtensions {

	@Inject extension SCTUnitJavaNaming
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension SCTUnitJavaExpressionExtensions
	@Inject extension CallbackExtensions
	@Inject extension SExecExtensions
	@Inject extension JavaSCTUnitGenmodelEntries
	@Inject extension Naming

	override String mockingImports(SCTUnitClass it, GeneratorEntry entry) '''
		«IF !scopesWithOperations.nullOrEmpty»
			import static org.mockito.Mockito.*;
			import static org.hamcrest.CoreMatchers.*;
			
			import org.mockito.invocation.InvocationOnMock;
			import org.mockito.stubbing.Answer;
			
			«FOR scope : scopesWithOperations»
				«scope.operationCallbackImport(entry)»
			«ENDFOR»
		«ENDIF»
	'''
	
	def scopesWithOperations(SCTUnitClass it) {
		statechart.scopes.filter[hasOperations]
	}
	
	def dispatch String operationCallbackImport(Scope scope, GeneratorEntry entry) ''''''
	
	def dispatch String operationCallbackImport(InternalScope scope, GeneratorEntry entry) '''
		import «entry.statechartBasePackage».«scope.getStatechart.statemachineClassName».«scope.operationCallbackClass»;
	'''
	
	def dispatch String operationCallbackImport(InterfaceScope scope, GeneratorEntry entry) '''
		«IF !scope.name.nullOrEmpty»
			import «entry.statechartBasePackage».«scope.getStatechart.statemachineClassName».«scope.interfaceTypeName»;
		«ELSE»
			import «entry.statechartBasePackage».«scope.getStatechart.statemachineClassName».«scope.operationCallbackClass»;
		«ENDIF»
	'''

	def dispatch String mockOperationCallbacks(Scope it) {
		// Should never be called
	}

	def dispatch String mockOperationCallbacks(InterfaceScope it) {
		'''
			«mockObjectName» = mock(«IF !name.nullOrEmpty»«interfaceTypeName».«ENDIF»«operationCallbackClass».class);
			«setOperationCallback»
		'''
	}

	def dispatch String mockOperationCallbacks(InternalScope it) {
		'''
			«mockObjectName» = mock(«operationCallbackClass».class);
			«setOperationCallback»
		'''
	}
	
	override String generatePositiveVerify(VerifyCalledStatement it) {
		var scope = it.reference.operation.getScope;
		val params = it.reference.argumentExpressions
		'''
			«IF params.nullOrEmpty»
				verify(«scope.mockObjectName», «IF it.times === null»atLeastOnce()«ELSE»atLeast(«it.times.value»)«ENDIF»).«it.operationName»(«FOR param : it.reference.operation.parameters SEPARATOR ', '»any«param.type.targetLanguageName.toFirstUpper»()«ENDFOR»);
			«ELSE»
				verify(«scope.mockObjectName», «IF it.times === null»atLeastOnce()«ELSE»atLeast(«it.times.value»)«ENDIF»).«it.operationName»(«FOR param : params SEPARATOR ', '»(«param.code»)«ENDFOR»);
			«ENDIF»
			 
		'''
	}
	
	override generateNegativeVerify(VerifyCalledStatement vs) {
		var scope = vs.reference.operation.getScope;
		val params = vs.reference.argumentExpressions
		'''
			«IF params.nullOrEmpty»
				verify(«scope.mockObjectName», never()).«vs.operationName»(«FOR param : vs.reference.operation.parameters SEPARATOR ', '»any«param.type.targetLanguageName.toFirstUpper»()«ENDFOR»);
			«ELSE»
				verify(«scope.mockObjectName», never()).«vs.operationName»(«FOR param : params SEPARATOR ', '»(«param.code»)«ENDFOR»);
			«ENDIF»
			 
		'''
	}

	protected def CharSequence getCaptureName(Parameter param, VerifyCalledStatement ve) {
		'''«param.type.argumentCapture»«ve.operationName»_«ve.statementIndex»_«ve.reference.operation.parameters.indexOf(param)»'''
	}

	protected def String getOperationName(VerifyCalledStatement it) {
		reference.getOperation.name.toFirstLower
	}

	protected def getStatementIndex(TestStatement stmt) {
		(stmt.eContainer.eGet(stmt.eContainingFeature) as List<TestStatement>).indexOf(stmt)
	}

	override String generateMockReturn(MockReturnStatement stm) {
		var scope = stm.reference.operation.getScope;
		'''
			when(«scope.mockObjectName».«stm.reference.getOperation.name.toFirstLower»(«FOR Parameter p : stm.operationParameters SEPARATOR ','»«IF stm.reference.argumentExpressions.nullOrEmpty»any«p.type.targetLanguageName.toFirstUpper»()«ELSE»«stm.reference.argumentExpressions.get(stm.operationParameters.indexOf(p)).code»«ENDIF»«ENDFOR»)).thenAnswer(new Answer<«stm.reference.operation.type.targetLanguageName.toFirstUpper»>() {
				@Override
				public «stm.reference.operation.type.targetLanguageName.toFirstUpper» answer(InvocationOnMock invocation) {
					«IF stm.value.customAnswer»
						Object[] args = invocation.getArguments();
						«FOR param: stm.reference.operation.parameters»
							«param.type.targetLanguageName.toFirstUpper» «param.name» = («param.type.targetLanguageName.toFirstUpper») args[«stm.reference.operation.parameters.indexOf(param)»];
						«ENDFOR»
					«ENDIF»
					return «stm.value.code»;
				}
			});
			 
		'''
	}
	
	protected def List<Parameter> getOperationParameters (MockReturnStatement it){
		reference.getOperation.parameters
	}
}
