/** 
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.generator.genmodel.ui.templates

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.GeneratorExtensions
import com.yakindu.sct.generator.core.extensions.ILibraryDescriptor
import com.yakindu.sct.generator.core.extensions.LibraryExtensions
import com.yakindu.sct.generator.core.library.IDefaultFeatureValueProvider
import com.yakindu.sct.generator.genmodel.services.SGenGrammarAccess
import com.yakindu.sct.generator.genmodel.ui.internal.GenmodelActivator
import com.yakindu.sct.model.sgen.FeatureType
import com.yakindu.sct.model.sgen.GeneratorModel
import org.eclipse.jface.text.templates.ContextTypeRegistry
import org.eclipse.jface.text.templates.Template
import org.eclipse.jface.text.templates.TemplateContext
import org.eclipse.jface.text.templates.persistence.TemplateStore
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper
import org.eclipse.xtext.ui.editor.templates.DefaultTemplateProposalProvider

import static extension org.eclipse.xtext.EcoreUtil2.*

/** 
 * @author andreas muelder - Initial contribution and API
 */
class SGenTemplateProposalProvider extends DefaultTemplateProposalProvider {

	@Inject SGenGrammarAccess gaccess
	@Inject SGenProposalCreator creator

	final ContextTypeIdHelper helper

	@Inject new(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
		super(templateStore, registry, helper)
		this.helper = helper
	}

	override protected void createTemplates(TemplateContext templateContext, ContentAssistContext context,
		ITemplateAcceptor acceptor) {
		super.createTemplates(templateContext, context, acceptor)
		val id = helper.getId(gaccess.getFeatureConfigurationRule())
		if (templateContext.getContextType().getId().equals(id)) {
			createFeatureConfigurationTemplates(templateContext, context, acceptor)
		}
	}

	def private void createFeatureConfigurationTemplates(TemplateContext templateContext, ContentAssistContext context,
		ITemplateAcceptor acceptor) {
		val model = context.currentModel.getContainerOfType(GeneratorModel)
		val generatorDescriptor = GeneratorExtensions.getGeneratorDescriptor(model.generatorId)
		if (!generatorDescriptor.isPresent()) {
			return
		}
		val libraryDescriptor = LibraryExtensions.getLibraryDescriptor(generatorDescriptor.get().libraryID)
		val library = libraryDescriptor.featureTypeLibrary
		val valueProvider = getValueProvider(libraryDescriptor)
		library.types.forEach [ type |
			val template = createTemplate(type, valueProvider, context)
			val proposal = createProposal(template, templateContext, context, template.image, template.relevance)
			acceptor.accept(proposal)
		]
	}

	def private getValueProvider(ILibraryDescriptor desc) {
		desc.createFeatureValueProvider(
			GenmodelActivator::getInstance().getInjector(GenmodelActivator::COM_YAKINDU_SCT_GENERATOR_GENMODEL_SGEN))
	}

	def private createTemplate(FeatureType type, IDefaultFeatureValueProvider provider,
		ContentAssistContext context) {
		new Template('''«type.name» feature'''.toString, '''Creates feature «type.name»'''.toString, type.name,
			creator.createProposal(type, provider, context.currentModel), false)
	}

}
