/** 
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.generator.genmodel.ui.wizard

import com.google.common.collect.Lists
import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.typesystem.GenericTypeSystem
import com.yakindu.sct.generator.core.extensions.IGeneratorDescriptor
import com.yakindu.sct.generator.core.extensions.ILibraryDescriptor
import com.yakindu.sct.generator.genmodel.ui.internal.GenmodelActivator
import com.yakindu.sct.model.sgen.FeatureType
import com.yakindu.sct.model.sgen.FeatureTypeLibrary
import com.yakindu.sct.model.sgen.GeneratorModel
import com.yakindu.sct.model.sgen.SGenFactory
import java.util.List
import org.eclipse.emf.common.util.EList
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.resource.ResourceSet
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl

import static extension com.yakindu.sct.generator.core.extensions.LibraryExtensions.*

class ModelCreator {

	val String OUTLET_FEATURE = "Outlet";
	val String OUTLET_FEATURE_TARGET_PROJECT = "targetProject";
	val String OUTLET_FEATURE_TARGET_FOLDER = "targetFolder";

	final extension SGenFactory = SGenFactory.eINSTANCE
	final extension TypesFactory = TypesFactory.eINSTANCE
	final extension ExpressionsFactory = ExpressionsFactory.eINSTANCE
	final IGeneratorDescriptor descriptor
	final List<EObject> eobjects

	new(IGeneratorDescriptor selectedGenerator, List<EObject> objects) {
		this.descriptor = selectedGenerator
		this.eobjects = objects
	}

	def GeneratorModel create() {
		val genModel = createGeneratorModel() => [
			generatorId = descriptor.id
			entries += eobjects.map[object|object.createGeneratorEntry]
		]

		genModel.extractVariables

		genModel

	}

	def protected extractVariables(GeneratorModel model) {

		val outlets = model.entries.map[getFeatureConfiguration(OUTLET_FEATURE)].filterNull

		val targetProject = createProperty => [
			typeSpecifier = createTypeSpecifier => [
				type = GenericTypeSystem.instance.getType("string")
			]
			name = "PROJECT"
			const = true
			initialValue = createPrimitiveValueExpression => [
				value = createStringLiteral => [
					value = outlets.head?.getParameterValue(OUTLET_FEATURE_TARGET_PROJECT)?.stringValue ?: ""
				]
			]
		]

		val targetFolder = createProperty => [
			typeSpecifier = createTypeSpecifier => [
				type = GenericTypeSystem.instance.getType("string")
			]
			name = "FOLDER"
			const = true
			initialValue = createPrimitiveValueExpression => [
				value = createStringLiteral => [
					value = outlets.head?.getParameterValue(OUTLET_FEATURE_TARGET_FOLDER)?.stringValue ?: ""
				]
			]
		]

		model.properties += targetProject
		model.properties += targetFolder

		outlets.forEach [ outlet |
			outlet.parameterValues.filter[parameter.name == OUTLET_FEATURE_TARGET_PROJECT].forEach [
				expression = createElementReferenceExpression => [
					reference = targetProject
				]
			]
			outlet.parameterValues.filter[parameter.name == OUTLET_FEATURE_TARGET_FOLDER].forEach [
				expression = createElementReferenceExpression => [
					reference = targetFolder
				]
			]
		]
	}

	def protected createGeneratorEntry(EObject eobject) {
		createGeneratorEntry() => [ entry |
			entry.keyword = descriptor.keyword
			entry.elementRef = eobject
			entry.features += descriptor.featureTypes.map[type|createFeatureConfiguration(entry, type)].filter [
				it !== null && !parameterValues.isEmpty
			]
		]
	}

	def private createFeatureConfiguration(EObject object, FeatureType featureType) {
		val injector = GenmodelActivator.getInstance().getInjector(
			GenmodelActivator.COM_YAKINDU_SCT_GENERATOR_GENMODEL_SGEN)
		val libraryDescriptor = descriptor.libraryID.libraryDescriptor
		val library = libraryDescriptor.featureTypeLibrary
		val valueProvider = libraryDescriptor.createFeatureValueProvider(injector)
		for (type : library.types) {
			if (type.name.equals(featureType.name)) {
				return valueProvider.createDefaultFeatureConfiguration(type, object)
			}
		}
		return null
	}

	def List<FeatureType> getFeatureTypes(IGeneratorDescriptor descriptor) {
		var features = Lists.newArrayList()
		val libraryDescriptor = descriptor.libraryID.libraryDescriptor
		var FeatureTypeLibrary lib = libraryDescriptor.featureTypeLibrary
		if (lib !== null) {

			var EList<FeatureType> types = lib.getTypes()
			// Only add the required features to the default model
			for (FeatureType featureType : types) {
				if(!featureType.isOptional()) features.add(featureType)
			}

		}
		return features
	}
}
