/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.cpp

import com.google.inject.Inject
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.generator.base.ISCTUnitGenerator
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries
import com.yakindu.sctunit.generator.cpp.extensions.GTest
import com.yakindu.sctunit.generator.cpp.extensions.Genmodel
import com.yakindu.sctunit.generator.cpp.extensions.JUnitTest
import com.yakindu.sctunit.generator.cpp.extensions.TimerService
import com.yakindu.sctunit.generator.cpp.extensions.TimerServiceHeader
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.TestPackage
import org.eclipse.xtext.generator.IFileSystemAccess
import com.yakindu.sctunit.generator.cpp.extensions.TimerServiceDependencies

/**
 * 
 * @author florian antony - Initial contribution and API
 * @author oliver bohl
 * @author Johannes Dicks - Refactoring based on EFS encapsulation
 * @author Axel Terfloth - Initialize statechart execution flow.
 * 
 */
class CppSCTUnitGenerator implements ISCTUnitGenerator {

	@Inject extension JUnitTest jUnitTest
	@Inject extension GTest gTest
	@Inject extension Genmodel
	@Inject protected extension CSCTUnitGenmodelEntries
	@Inject extension TimerService timerService
	@Inject extension TimerServiceHeader timerServiceHeader
	@Inject extension TimerServiceDependencies timerServiceDependencies

	@Inject
	protected ICoreLibraryHelper helper

	override generate(GeneratorEntry entry, IFileSystemAccess fsa) {

		prepareGenerator(entry)
		
		generateJUnitWrapper(entry, fsa)
		
		// C++ & sgen
		if (entry.testPackage.testClass !== null) {
			
			var sctunitClass = entry.testPackage.testClass
			var String gtestOutletFolder = entry.targetFolderString;
						
			gTest.generateGTest(sctunitClass, fsa, gtestOutletFolder)
			timerService.generateTimerService(sctunitClass, fsa, gtestOutletFolder)
			timerServiceHeader.generateTimerServiceHeader(sctunitClass, fsa, gtestOutletFolder)
			timerServiceDependencies.generateTimerServiceDependencies(sctunitClass, fsa, gtestOutletFolder)
		
			if(entry.isSGen)
				sctunitClass.generateGenmodel(fsa);
		}
	}
	
	def protected void prepareGenerator(GeneratorEntry entry) {	
	}
	
	
	def protected generateJUnitWrapper(GeneratorEntry entry, IFileSystemAccess fsa) {	
		var targetProjectPath = entry.targetProject.javaPackageForProjectName
		if (entry.isJUnitWrapper) {
			entry.testPackage.generateJUnitTest(fsa, targetProjectPath, this, entry)
		}
		
	}
	
	def getTargetProject(GeneratorEntry entry) {
		helper.getTargetProjectValue(entry).stringValue
	}
	
	def protected getTestClass(TestPackage it) {
		it.eAllContents.filter(SCTUnitClass).head
	}
	
	

	
}
