package com.itemis.create.sunit

import com.yakindu.base.types.TypeBuilder
import com.google.inject.Inject
import com.yakindu.base.types.Operation

class SUnitBuilder {
	
	@Inject protected extension TypeBuilder
	
	def _testClass(String name) {
		_public(_complexType(name)) => [
			_annotate(SUnitAnnotations.TEST_CLASS_ANNOTATION)
		]
	} 
	
	def _testMethod(String name) {
		_public(_test(_op(name)))
	}
	
	def _test(Operation it) {
		_annotate(SUnitAnnotations.TEST_ANNOTATION)
	}
	
	def _ignore(Operation it) {
		_annotate(SUnitAnnotations.IGNORE_ANNOTATION)
	}
	
	def _sunit(String name) {
		_package(name) => [
			_annotate(SUnitAnnotations.SUNIT_ANNOTATION)
		]
	}
	
}