/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.sunit

import com.google.inject.Inject
import com.yakindu.base.types.TypeBuilder
import org.eclipse.emf.ecore.EObject
import com.yakindu.base.types.Operation

/**
 * SUnit contains a couple of declarations which will be used for modeling.
 *  
 * @author axel terfloth
 */
class SUnitLib {
	
	public static final String SUNIT_PACKAGE_NAME = "create.sunit"
	public static final String ASSERT_METHOD_NAME = "assert"
	public static final String MOCK_METHOD_NAME = "mock"
	public static final String RETURN_METHOD_NAME = "return"
	public static final String CALLED_METHOD_NAME = "called"
	public static final String TIMES_METHOD_NAME = "times"
	
	@Inject protected extension TypeBuilder
	
	
	def sunitPackage(EObject context) {
		context.eAllContents.filter(com.yakindu.base.types.Package).filter[SUNIT_PACKAGE_NAME == name].head	
	}
	
	def sunitAssert(EObject context) {
		context.sunitPackage?.member.filter(Operation).filter[ASSERT_METHOD_NAME == name].head
	}
	
	def sunitMock(EObject context) {
		context.sunitPackage?.member.filter(Operation).filter[MOCK_METHOD_NAME == name].head
	}
	
	def sunitReturn(EObject context) {
		context.sunitPackage?.member.filter(Operation).filter[RETURN_METHOD_NAME == name].head
	}
	
	def sunitCalled(EObject context) {
		context.sunitPackage?.member.filter(Operation).filter[CALLED_METHOD_NAME == name].head
	}
	
	def sunitTimes(EObject context) {
		context.sunitPackage?.member.filter(Operation).filter[TIMES_METHOD_NAME == name].head
	}
	
	def defineSunitPackage() {
		
		_package(SUNIT_PACKAGE_NAME) => [
			
			it.member += defineAssertMethod
			it.member += defineMockMethod
			it.member += defineCalledMethod
			it.member += defineTimesMethod
			it.member += defineReturnMethod
			
		]	
	}
	
	def protected defineAssertMethod() {
		_op(ASSERT_METHOD_NAME) => [
			_param("condition", _typeSpecifier(_boolean))
		]
	}
	
	def protected defineMockMethod() {
		_op(MOCK_METHOD_NAME) => [
			_param("parameters", _typeSpecifier(_any))
		]
	}
	
	def protected defineReturnMethod() {
		_op(RETURN_METHOD_NAME) => [
			_param("parameters", _typeSpecifier(_any))
		]
	}
	
	def protected defineCalledMethod() {
		_op(CALLED_METHOD_NAME) => [
			_param("parameters", _typeSpecifier(_any))
		]
	}
	
	def protected defineTimesMethod() {
		_op(TIMES_METHOD_NAME) => [
			_param("times", _typeSpecifier(_any))
		]
	}	
	
}