/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.sunit.generator.csharp.nunit.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.concepts.OutEvent
import com.itemis.create.base.generator.csharp.concepts.OutEventSubscriber
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpNamedInterfaceClasses
import com.itemis.create.sunit.generator.csharp.nunit.codemodel.NUnitAnnotations
import com.yakindu.base.base.NamedElement
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.TypesUtil
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import org.eclipse.emf.ecore.EObject
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

/**
 * Defines members for outgoing events in order to make the testing of them possible. 
 * 
 * @author Laszlo Kovacs
 */

@Singleton
class OutEventMembers {
	@Inject protected extension TypeBuilder
	@Inject protected extension TypesUtil
	@Inject protected extension CsharpTypeBuilder
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	
	@Inject protected extension IVariableCode
	@Inject protected extension GeneratorAssignment
	@Inject protected extension OriginTracing
	@Inject protected extension StatechartAnnotations
	@Inject protected extension OutEventSubscriber
	@Inject protected extension NUnitAnnotations
	@Inject protected extension Literals
	@Inject protected extension CsharpNamedInterfaceClasses
	@Inject protected extension OutEvent
	@Inject protected extension StatemachineClass
	@Inject protected extension Statechart2TypeTransformation
	
	//TODO: Use this to first define the event raiser based on the event.
	/** 
	 * This methods defines a raised flag for an out event.
	 */
	def create r : createProperty defineOutEventMembers(TypedDeclaration it) {
		
		r.name = '''«(eContainer as NamedElement).name»«name.toFirstUpper»Raised'''
		r.typeSpecifier = _typeSpecifier(_boolean)
		r.generateDefinitionWith[r.variableDeclarationCode]
		r._private
		r.traceOrigin(it)
	}
	
	def create r : createProperty defineOutEventValueMembers(TypedDeclaration it) {
		r.name = '''«(eContainer as NamedElement).name»«name.toFirstUpper»Value'''
		r.typeSpecifier = _typeSpecifier(it.type)
		r.generateDefinitionWith[r.variableDeclarationCode]
		r._private
		r.traceOrigin(outEventMember)
	}
	
	/** 
	 * Defines members for each outgoing event defined by this complex type.
	 * Also defines handler methods for each of them.
	 * All defined objects are added to the testclass as features.
	 */
	def void defineOutEventMembers(EObject it) {
		val testclass = eAllContents.filter(ComplexType).filter[isTestFixture].head
		eAllContents
			.filter(EventDefinition)
			.filter[ direction === Direction.OUT ]
			.forEach[ e |
				e.addSibling(((e.origin as EObject).origin as Event).defineOutEventMembers)
				if (e.type !== null && e.type.name != 'void')
					e.addSibling(((e.origin as EObject).origin as Event).defineOutEventValueMembers)
				e.addSibling(((e.origin as EObject).origin as Event).defineHandlerForEvent(testclass))
			]
	}	
	
	//TODO: Replace this with 'OutEventHandler'
	def defineHandlerForEvent(TypedDeclaration oe, ComplexType testClass){
		val oeMember = oe.outEventMember
		val oeValueMember = oe.outEventValueMember
		_variable(oeMember.name.toFirstUpper + 'Handler', _void) => [
			_handler
			_private
			traceOrigin((oe as EventDefinition).eventDefinition)
			generateDefinitionWith['''
			private void «oeMember.name.toFirstUpper»Handler(«oeMember.getContainingStatechartType.asLiteral»«oeMember.getIfaceForEvent» sender, «IF oeValueMember !== null»«oeMember.getContainingStatechartType.asLiteral»«oeMember.getIfaceForEvent».«oe.name.toFirstUpper»«ENDIF»EventArgs e){
				«oeMember.name» = true;
				«IF oeValueMember !== null»«oeValueMember.name» = e.Payload;«ENDIF»
			}
			''']
		]
	}
	
	def getIfaceForEvent(Property prop){
		if(prop.isInNamedIface) return "." + (prop.eContainer.eContainer as ComplexType).features.filter(ComplexType).filter[originTraces.lastOrNull === prop.eContainer.originTraces.lastOrNull].head.name
		else ""
	}
	/**
	 * Returns the event raised member for an event if it is defined or null if it is not defined yet.
	 */
	def outEventMember(TypedDeclaration it) {
		_createCache_defineOutEventMembers.get(#[it])
	}
	
	/**
	 * Returns the event value member for an event if it is defined or null if it is not defined yet.
	 */
	def outEventValueMember(TypedDeclaration it) {
		_createCache_defineOutEventValueMembers.get(#[it])
	}

}
