/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.GeneratorAssignment.DeclarationAdapter
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.core.concepts.InternallyDefinedTypeAnnotation
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.codepattern.ClassCode
import com.itemis.create.base.generator.csharp.concepts.EventRaiser
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Operation
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.codemodel.InterfaceContext
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import java.util.ArrayList
import java.util.List
import org.eclipse.emf.ecore.EObject

import static com.yakindu.sct.types.resource.Statechart2TypeTransformation.NAMED_IFACE_CLASS

/**
 * 
 * @author laszlo kovacs
 *
 */
@Singleton
class CsharpNamedInterfaceClasses extends NamedInterfaceClasses{
		
	@Inject protected extension ClassCode
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension IVariableCode
	@Inject protected extension IMethodCode
	@Inject protected extension GeneratorAssignment
	@Inject protected extension OriginTracing
	@Inject protected extension SExecExtensions
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension InternallyDefinedTypeAnnotation
	@Inject protected extension CsharpClass
	@Inject protected extension EventRaiser
	@Inject protected extension CsharpGenmodelEntries
	@Inject protected extension InterfaceContext
	@Inject protected GeneratorEntry entry
	
	
	override List<ComplexType> create new ArrayList<ComplexType> namedInterfaceClasses(ExecutionFlow flow) {

		flow.scopes.filter(InterfaceScope).filter[isNamedScope].forEach [ scope |
			val nic = scope.namedInterfaceClass
			flow.stateMachineClass.features += nic
			if(scope.defineParent) nic.ifaceConstructor
			it.add(scope.namedInterfaceClass)
		]
	}
	
	override protected ComplexType create _csharpClass(scope.name.asEscapedIdentifier.toFirstUpper + "Impl") createNamedInterfaceClass(InterfaceScope scope) {
		
		superTypes += createTypeSpecifier => [ ts |
			ts.type = scope.createNamedInterface	
		]
		_private
		_annotate(NAMED_IFACE_CLASS)
		traceOrigin(scope)
		val part = _part(scope.name, it) => [
			if(scope.defineParent) _required
			_readonly
			_private
			traceOrigin(scope.origin)
		]
		features += part
		scope.stateMachineClass.features += scope.scopeInterface
		scope.stateMachineClass.features += _part(scope.name, scope.namedInterface) => [
			_public
			generateDefinitionWith[getterSetter(true, false,"")]
		]
		generateDeclarationWith[ part.variableDeclarationCode ]	
	}
	
	def protected ComplexType create _csharpInterface("I" + nic.name.toFirstUpper) createNamedInterface(InterfaceScope nic) {
		_public
	}
	
	def protected dispatch scopeInterface(Scope it){
		if(isNamedScope)
			namedInterface
		else stateMachineClass
	}
	
	def protected dispatch scopeInterface(EObject it){
		stateMachineClass
	}
	
	def protected namedInterface(Scope it) {
		_createCache_createNamedInterface.get(#[it])
	}
	
	def protected createNamedInterfaceClass(Scope it) {
		_createCache_createNamedInterfaceClass.get(#[it])
	}
	
	def copyNamedIfaceFunctionDeclarations(ExecutionFlow flow){
		flow.namedInterfaceClasses.forEach[nic |
			nic.features.filter(Operation).filter[
				name != nic.name &&
				!(nic.origin as InterfaceScope).outEventRaisers.contains(it)
			].forEach[ op |
				(nic.origin as InterfaceScope).scopeInterface.features += op.copy => [
					op.eAdapters.filter(DeclarationAdapter).forEach[ adapter |
						it.eAdapters += adapter
					]
					if(op.eAdapters.filter(DeclarationAdapter).nullOrEmpty)
						generateDeclarationWith[ methodDeclarationCode ]
				]
			]
		]
	}
	
	def private outEventRaisers(InterfaceScope it){
		val allOutEventRaisers = newArrayList
		eventDefinitions.filter[direction === Direction.OUT].forEach[oe | 
			allOutEventRaisers += oe.eventRaiser
		]
		allOutEventRaisers
	}
	
	def defineParent(InterfaceScope scope){
		if(scope.flow !== null && scope.needsStatemachineReference || entry.tracingGeneric || entry.isThreadSafeAccess)
			true
		else
			false
	}
	
}
