/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.transformation.EventBufferTransformation
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.Expression
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.extensions.GeneratorPredicate
import com.yakindu.sct.generator.core.submodules.lifecycle.EventCode
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

import static com.itemis.create.statechart.generator.csharp.codemodel.CsharpEventQueueImplementation.*

class CsharpStatemachineEventCode implements EventCode {
	
	@Inject protected extension SExecExtensions
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension GeneratorPredicate
	@Inject protected extension CsharpStatemachineExpressionCode
	@Inject protected extension EventProcessing
	@Inject protected extension ExpressionBuilder
	@Inject protected extension ExpressionExtensions
	@Inject protected extension StatemachineClass
	@Inject protected extension OriginTracing
	@Inject protected extension Literals
	@Inject protected extension EventBufferTransformation

	
	override eventClearCode(ExecutionFlow flow, Expression event) '''
		«event.code» = false;
	'''
	
	override eventNextCode(ExecutionFlow it) '''
		«GET_NEXT_EVENT_METHOD_NAME»();
	'''
		
	override getNextEventCode(ExecutionFlow it) {
		'''
		«GET_NEXT_EVENT_METHOD_NAME»()'''
	}
	
	override eventMoveCode(ExecutionFlow flow, Expression source, Expression target) {
		//Not used
	}

}
