/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.csharp.codemodel.CsharpNaming
import com.itemis.create.base.generator.csharp.concepts.EventRaiser
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpStatemachineEvents
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpTraceEvent
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.templates.TraceCodeGenerator
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sexec.Trace
import com.yakindu.sct.model.sexec.TraceBeginRunCycle
import com.yakindu.sct.model.sexec.TraceEndRunCycle
import com.yakindu.sct.model.sexec.TraceReactionWillFire
import com.yakindu.sct.model.sexec.TraceStateEntered
import com.yakindu.sct.model.sexec.TraceStateExited
import com.yakindu.sct.model.sexec.UnscheduleTimeEvent
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import org.eclipse.emf.ecore.EObject

import static com.yakindu.sct.generator.core.tracing.TraceEvent.TRACE_EVENT_TYPE_MAP

/**
 * @author laszlo kovacs
 */
class CsharpTraceCode extends TraceCodeGenerator {
	
 	@Inject extension protected CsharpGenmodelEntries
 	@Inject extension protected CsharpNaming
 	@Inject extension protected OriginTracing
 	@Inject extension protected StatemachineClass
 	@Inject extension protected StateEnum
 	@Inject extension protected EventRaiser
 	@Inject extension protected CsharpTraceEvent
 	@Inject extension protected CsharpStatemachineExpressionCode
 	@Inject extension protected CsharpStatemachineEvents
 	@Inject extension protected Statechart2TypeTransformation

	def dispatch CharSequence traceCode(Trace it){ 
		val message = notifyTrace
		'''
		«IF (entry.tracingGeneric && !message.empty)»«IF isInNamedIface || isInNamedInterface»parent.«ENDIF»«stateMachineClass.traceEventForStm.eventRaiser.name»(«notifyTrace»);«ENDIF»
		'''
	}	

	override dispatch CharSequence traceCode(Object it) {
		if (entry.tracingGeneric) notifyTrace else ''''''
	}
	
	def CharSequence traceCode(EObject it, Object value) '''
		«IF (entry.tracingGeneric)»«IF isInNamedIface || isInNamedInterface»parent.«ENDIF»«stateMachineClass.traceEventForStm.eventRaiser.name»(«it.notifyTrace(value)»)«ENDIF»'''
	
	def protected dispatch notifyTrace(Property it) 
		'''new «genericTraceEvent.name»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get(it.eClass.name)», «machine», null!, «stateMachineClass.traceEventFeature».«featureEnumMemberName», «it.code»)'''
	
	
	def protected dispatch notifyTrace(Object it, Object value) '''failed attempt to trace ... '''
	
	def protected dispatch notifyTrace(Trace it, Object value) '''«it.notifyTrace»'''
	
	def protected dispatch notifyTrace(Property it, Object value) 
		'''new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get(it.eClass.name)», «machine», null!, «stateMachineClass.traceEventFeature».«featureEnumMemberName», «value»)'''

	def protected dispatch notifyTrace(Event it, Object value) 
		'''new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get(it.eClass.name)», «machine», null!, «stateMachineClass.traceEventFeature».«featureEnumMemberName», «value»)'''

	def protected dispatch notifyTrace(TraceBeginRunCycle it) 
		'''new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get(it.eClass.name)», «machine»)'''

	def protected dispatch notifyTrace(TraceEndRunCycle it) 
		'''new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get(it.eClass.name)», «machine»)'''


	def protected dispatch notifyTrace(TraceStateEntered it) 
		'''new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get(it.eClass.name)», «machine», «stateMachineClass.stateEnum».«it.state.getStateEnumFor.name», null!, null!)'''


	def protected dispatch notifyTrace(TraceStateExited it) 
		'''new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get(it.eClass.name)», «machine», «stateMachineClass.stateEnum».«it.state.getStateEnumFor.name», null!, null!)'''


	def protected dispatch notifyTrace(TraceReactionWillFire it) {
		if (reaction.isTransition && reaction.eContainer instanceof ExecutionState) {
			val state = (reaction.eContainer as ExecutionState).sourceElement as RegularState
			val transitionId = state.outgoingTransitions.indexOf(reaction.sourceElement)
			'''
				new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get(it.eClass.name)», «machine», «stateMachineClass.stateEnum».«(reaction.eContainer as ExecutionState).getStateEnumFor.name», null!, «transitionId»)'''
		}
		else ''''''
	}

	def protected dispatch notifyTrace(ScheduleTimeEvent it) '''
		«stateMachineClass.traceEventForStm.eventRaiser.name»(new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get(it.eClass.name)», «machine», null!, null!, «flow.timeEvents.indexOf(timeEvent)»));
	'''
	
	def protected dispatch notifyTrace(UnscheduleTimeEvent it) '''
		«stateMachineClass.traceEventForStm.eventRaiser.name»(new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get(it.eClass.name)», «machine», null!, null!, «flow.timeEvents.indexOf(timeEvent)»));
	'''
	
	override traceEnterCode(ExecutionFlow it) {
		if (entry.tracingGeneric) '''
			«stateMachineClass.traceEventForStm.eventRaiser.name»(new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get("traceEnterCode")», «machine»));
		'''	
		else ''''''
	}
	
	
	override traceExitCode(ExecutionFlow it) {
		if (entry.tracingGeneric) '''
			«stateMachineClass.traceEventForStm.eventRaiser.name»(new «genericTraceEvent»<«stateMachineClass.name», «stateMachineClass.stateEnum»?, «stateMachineClass.traceEventFeature»?>(«traceEventType».«TRACE_EVENT_TYPE_MAP.get("traceExitCode")», «machine»));
		'''	
		else ''''''
	}
	
	def protected getStateEnumFor(ExecutionState state){
		state.stateMachineClass.stateEnum.enumerator.filter[(origin as EObject).origin === state.origin].head
	}
	
	def protected machine(EObject it){
		if(isInNamedIface || isInNamedInterface)
			'''parent'''
		else
			'''this'''
	}
	
	
}
