/**
 * Copyright (c) 2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.transformation

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.concepts.EventRaiser
import com.itemis.create.base.model.bindings.OutProperty
import com.itemis.create.base.model.bindings.PropertyChangedNotification
import com.itemis.create.base.model.bindings.ReactiveModel
import com.itemis.create.base.model.core.EventModel
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpStatemachineNaming
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentOperator
import com.yakindu.base.expressions.expressions.BlockExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.LambdaExpression
import com.yakindu.base.expressions.expressions.MetaCall
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Part
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.MicroStep
import com.yakindu.sct.model.sexec.concepts.OnInitHook
import com.yakindu.sct.model.sexec.concepts.OnUpdateStateHook
import com.yakindu.sct.model.sexec.concepts.PropertyBinder
import com.yakindu.sct.model.sexec.concepts.RunCycleMethod
import com.yakindu.sct.model.sexec.concepts.SubMachine
import org.eclipse.emf.ecore.util.EcoreUtil

/**
 * This class is responsible to translate concepts defined in Sexec to codemodel.
 * 
 * @author laszlo kovacs
 *
 */
class ExecFlowConceptsTransformation {
	
	@Inject protected extension SubMachine
	@Inject protected extension RunCycleMethod
	@Inject protected extension ConceptSequenceTransformation
	@Inject protected extension CsharpClass
	@Inject protected extension TypeBuilder
	@Inject protected extension OriginTracing
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IVariableCode
	@Inject protected extension IMethodCode
	@Inject protected extension PropertyBinder
	@Inject protected extension OnInitHook
	@Inject protected extension ReactiveModel
	@Inject protected extension ExpressionBuilder
	@Inject protected extension ExpressionExtensions
	@Inject protected extension OutProperty
	@Inject protected extension PropertyChangedNotification
	@Inject protected extension OutPropertyEventHandler
	@Inject protected extension MicroStep
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension OnUpdateStateHook
	
	@Inject protected extension EventModel
	@Inject protected extension EventRaiser
	
	
	protected extension TypesFactory = TypesFactory.eINSTANCE
	
	def transformExecDefinedConcepts(ExecutionFlow flow, ComplexType stmClass){
		
		flow.eAllContents.filter(ArgumentExpression).forEach[ argExp |
			if(argExp.featureOrReference === _function_apply){
				if(argExp instanceof FeatureCall)
					EcoreUtil.replace(argExp, argExp.owner._call(_op("Invoke")))
			}
		]
			
		if(flow.submachineContextType !== null){
			
			//Replace init lambda expression with event raiser call, as in C# the raiser with it's implementation is defined and generated in "CsharpStatemachineEvents"
			//TODO: Re-evaluate whether this is the most proper solution or not
			flow.eAllContents.filter(LambdaExpression).filter[expression instanceof BlockExpression && (expression as BlockExpression)
				.expressions.exists[exp | 
					exp instanceof MetaCall &&
					(exp as MetaCall).feature instanceof Operation &&
					storeEventConcept.appliesTo((exp as MetaCall).feature as Operation)
				]
			].forEach[
				val metaCall = (expression as BlockExpression).expressions.filter(MetaCall).filter[exp |
					(exp as MetaCall).feature instanceof Operation &&
					storeEventConcept.appliesTo((exp as MetaCall).feature as Operation)
				].head
				expression = (metaCall.owner.featureOrReference as TypedDeclaration).defineEventRaiser._ref
			]
			
			flow.features.filter(Part).filter[type === flow.submachineContextType].forEach[ subCtxPart |
				(flow.onInitHook.implementation as BlockExpression).expressions.add(0, subCtxPart._ref._assign(subCtxPart.initialValue))
				subCtxPart._required
				subCtxPart._synthetic
			]
			
			val csharpClass =  _csharpClass(flow.submachineContextType.copy => [
				_synthetic
				traceOrigin(flow.submachineContextType)
				features.forEach[ f |
					f._required
					f._synthetic
					if(f instanceof Property)
						f.generateDefinitionWith[f.variableDeclarationCode]
					else if(f instanceof Operation)
						f.generateDefinitionWith[f.methodDefinitionCode]
				]
			])
			
			csharpClass.eAllContents.filter(TypedDeclaration).forEach[ td |
				if(td.type === _function)
					td.typeSpecifier = createTypeSpecifier => [ ts |
						ts.type = _action
					]
			]
				
			stmClass.features += csharpClass
			
		}
		
		flow.eAllContents.filter(Property).filter[isOutProperty].forEach[ td |
				td.outPropertyObservable.typeSpecifier = createTypeSpecifier => [ ts |
					ts.type = _object
				]
			]
		
		if(flow.appliesBinder){
			
			//Replace 'binding_observer_'s with 'OutPropertyEventHandler' subscriptions to the target and put them into 'onInitHook'
			val observers = newHashSet
			flow.eAllContents.filter(Property).forEach[ td |
				if(td.type === simpleObserverType){
					observers += td
					val propChangedEvent = td.originTraces.filter(TypedDeclaration).filter[!(type instanceof ComplexType)].head.propertyEventDefinition()
					val subMachineVar = td.originTraces.filter(TypedDeclaration).filter[type instanceof ComplexType].head()
					((td.initialValue as InitializationExpression).arguments.head.value as LambdaExpression).parameters += _parameter("e", _any)
					
					(flow.onInitHook.implementation as BlockExpression).expressions.add(0, subMachineVar._ref._dot(propChangedEvent)._assign(AssignmentOperator.ADD_ASSIGN, td.initialValue))
					td._required
				}
			]
			
			//Remove 'binding_observer_'s from 'execflow' as they are replaced with 'OutPropertyEventHandler'
			flow.features.removeAll(observers)
			
			flow.features.filter(Part).filter[type === binderType].forEach[ binderPart |
				(flow.onInitHook.implementation as BlockExpression).expressions.add(0, binderPart._ref._assign(binderPart.initialValue))
				binderPart._required
			]
			
			val csharpClass =  _csharpClass(binderType.copy => [ bt |
				bt._synthetic
				bt.traceOrigin(binderType)
				bt.features.forEach[ f |
					f._required
					f._synthetic
					if(f instanceof Property){
						f._private
						f.generateDefinitionWith[f.variableDeclarationCode]
					}
					else if(f instanceof Operation){
						f.generateDefinitionWith[f.methodDefinitionCode]	
					}
				]
				bt.features +=  _op(bt.name) => [
					val lambdaParam = _lambda_param("lambda_", _function)
					parameters += lambdaParam
					_no_return_type
					implementation = _block(
						bt.features.filter(Property).filter[type === _function].head._ref._assign(lambdaParam._ref)
					)
					generateDefinitionWith[methodDefinitionCode]
				]
			])
			
			csharpClass.eAllContents.filter(TypedDeclaration).forEach[ td |
				if(td.type === _function)
					td.typeSpecifier = createTypeSpecifier => [ ts |
						ts.type = _action
					]
			]
			
			csharpClass.eAllContents.filter(ArgumentExpression).forEach[ argExp |
				if(argExp.featureOrReference === _function_apply){
					if(argExp instanceof FeatureCall)
						EcoreUtil.replace(argExp, argExp.owner._call(_op("Invoke")))
				}
			]
			
			//Remove 'binding_observer_'s from 'onInitHook' as they are replaced with 'OutPropertyEventHandler'
			val observerCallsBlock = newHashSet()
			
			(flow.onInitHook.implementation as BlockExpression).expressions
			.filter(BlockExpression).map[expressions].flatten
			.filter(FeatureCall)
			.filter[
				owner instanceof ElementReferenceExpression &&
				(owner as ElementReferenceExpression).reference instanceof TypedDeclaration
			]
			.filter[
				((owner as ElementReferenceExpression).reference as TypedDeclaration).type.isSimpleObserverType
			].forEach[
				observerCallsBlock += it.eContainer
			]
			
			(flow.onInitHook.implementation as BlockExpression).expressions.removeAll(observerCallsBlock)
				
			stmClass.features += csharpClass
			
			if(flow.hasOnUpdateStateHook)
				flow.onUpdateStateHook => [
					name = name.toFirstUpper
					generateDefinitionWith[methodDefinitionCode]
				]
			
		}
		
		//Has to be after subCtx construction, as it requires the 'runCycle' to be present in the ExecFlow
		if(flow.runCycle !== null)
			stmClass.features += flow.runCycle.transformConcepts(stmClass)
		
		//TODO: This is currently only to replace '_traceEndRunCycle' and '_traceBeginRunCycle' from Operation bodies. Should be removed once those are not Sexec based
		if(flow.getRunSubmachineCycle !== null)
			flow.getRunSubmachineCycle.transformConcepts(stmClass)
			
		if(flow.microStep !== null)
			stmClass.features += flow.microStep =>[
				eAllContents
				.filter(ElementReferenceExpression)
				.filter[reference instanceof Operation]
				.forEach[
					var methodOp = _op((reference as Declaration).identifier)
					methodOp.traceOrigin(reference)
					stmClass.features += methodOp
					reference = methodOp
				]
			]
		flow.eAllContents
				.filter(ElementReferenceExpression)
				.filter[reference instanceof Operation && (reference as Operation).name === "react"]
				.forEach[
					var methodOp = _op((reference as Declaration).identifier)
					methodOp.traceOrigin(reference)
					stmClass.features += methodOp
					reference = methodOp
				]
		
	}
	
}