/**
 * Copyright (c) 2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.transformation

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.core.concepts.InternallyDefinedTypeAnnotation
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.model.bindings.OutProperty
import com.itemis.create.statechart.generator.csharp.codemodel.CsharpStatemachineNaming
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import org.eclipse.emf.common.util.TreeIterator
import org.eclipse.emf.ecore.EObject

/**
 * Maps a statechart Out property to an event which is called when the property's value changes and creates a delegate for it 
 * which represents the payload and the sender of the event.
 * It is called by client objects. 
 * 
 * @author Laszlo Kovacs
 */
@Singleton
class OutPropertyEventHandler {
	
	@Inject protected extension TypeBuilder
	@Inject protected extension OriginTracing
	@Inject protected extension InternallyDefinedTypeAnnotation
	@Inject protected extension OutProperty
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension SExecExtensions
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IVariableCode
	@Inject protected extension CsharpClass
	@Inject protected extension CsharpStatemachineNaming
	@Inject protected extension StatechartUtil
	
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	
	def void definePropertyChangedEvent(EObject it) {
		eAllContents.forOutProperty
		
		referencedStatecharts.forEach[
			eAllContents.forOutProperty	
		]
	}
	
	def protected forOutProperty(TreeIterator<EObject> content){
		content.filter(Property)
			.filter[ isOutProperty ]
			.toList
			.forEach[ prop |
				prop.propertyEventDefinition => [ 
					prop.scope.scopeClass.features += it
				]
			prop.scope.scopeClass.features += _propertyChangedEventArgs
		]
	}
	
	def create it : _part(e.name.toFirstUpper + "Changed") propertyEventDefinition(TypedDeclaration e) {
		typeSpecifier = createTypeSpecifier => [
			type = _event_handler
		]		
		generateDeclarationWith[variableDeclarationCode]
		_internallyDefinedType
		_event
		traceOrigin(e)
		_public
		const = false
		static = false
		
	}
	
	def ComplexType create _csharpClass("PropertyChangedEventArgs") _propertyChangedEventArgs(){
		_required
		superTypes += createTypeSpecifier => [
			type = _complexType("EventArgs") => [_required]
		]
		features += _newValue
	}
	
	def ComplexType create _complexType("EventHandler") _event_handler() {
		_nullable
		superTypes += createTypeSpecifier => [
			type = _propertyChangedEventArgs
		]
	}
	
	def create it : _variable("NewValue", _object) _newValue(){
		_required
		generateDefinitionWith[getterSetterSignature(true, true)]
	}
	
}