/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.json.transformation.model.util

import com.yakindu.sct.model.sgraph.Choice
import com.yakindu.sct.model.sgraph.Entry
import com.yakindu.sct.model.sgraph.EntryKind
import com.yakindu.sct.model.sgraph.Exit
import com.yakindu.sct.model.sgraph.FinalState
import com.yakindu.sct.model.sgraph.Region
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.Synchronization
import com.yakindu.sct.model.sgraph.Transition
import org.eclipse.gmf.runtime.notation.NotationFactory
import org.eclipse.gmf.runtime.notation.Routing

/**
 * Helper functions to create GMF Node Model classes 
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class NodeModelFactory {

	extension NotationFactory = NotationFactory.eINSTANCE

	def createRegionNode(Region region) {
		val result = createNode => [
			type = "Region"
			element = region
			layoutConstraint = createBounds
			styles += createShapeStyle => [
				fontName = "Verdana"
				fillColor = 16448250
				lineColor = 12632256
			]
		]
		// Add RegionName
		result.insertChild(createDecorationNode => [
			type = "RegionName"
			styles += createShapeStyle
			layoutConstraint = createLocation
		])
		// Add RegionFigureCompartment
		result.insertChild(createShape => [
			type = "RegionCompartment"
			element = region
			layoutConstraint = createBounds
		])
		return result
	}

	def createStateNode(State state) {
		val result = createNode => [
			type = "State"
			element = state
			styles += createShapeStyle => [
				fontName = "Verdana"
				fillColor = 15720400
				lineColor = 12632256
			]
			styles += createFontStyle
			styles += createBooleanValueStyle => [
				name = "isHorizontal"
				booleanValue = true
			]
			layoutConstraint = createBounds
		]
		result.insertChild(createDecorationNode => [
			element = state
			type = "StateName"
			styles += createShapeStyle
			layoutConstraint = createLocation
		])

		result.insertChild(createCompartment => [
			element = state
			type = "StateTextCompartment"
			insertChild(createShape => [
				type = "StateTextCompartmentExpression"
				layoutConstraint = createBounds
				styles += createShapeStyle => [
					fontName = "Verdana"
					lineColor = 4210752
				]
			])
		])
		result.insertChild(
			createCompartment => [
				type = "StateFigureCompartment"
			]
		)

		result
	}

	def createEntryNode(Entry entry) {
		val result = createNode => [
			type = entry.kind.entryNodeName
			element = entry
			layoutConstraint = createBounds
			styles += createShapeStyle => [
				fontName = "Verdana"
				fillColor = 0
				lineColor = 16777215
			]
			styles += createNamedStyle => [
				name = "allowColors"
			]
		]

		// Add BorderItemLabelContainer
		result.insertChild(createShape => [
			type = "BorderItemLabelContainer"
			styles += createShapeStyle => [
				fontName = "Verdana"
				lineColor = 4210752
			]
			layoutConstraint = createBounds
			insertChild(createDecorationNode => [
				type = "BorderItemLabel"
				styles += createShapeStyle
				layoutConstraint = createLocation
			])
		])
		result
	}

	def entryNodeName(EntryKind kind) {
		switch kind {
			case INITIAL:
				return "Entry"
			case SHALLOW_HISTORY:
				return "ShallowHistory"
			case DEEP_HISTORY:
				return "DeepHistory"
		}
	}

	def createExitNode(Exit exit) {
		val result = createNode => [
			type = "Exit"
			element = exit
			layoutConstraint = createBounds
			styles += createShapeStyle => [
				fontName = "Verdana"
				lineColor = 4210752
			]
		]

		result.insertChild(createShape => [
			type = "BorderItemLabelContainer"
			styles += createShapeStyle => [
				fontName = "Verdana"
				lineColor = 4210752
			]
			layoutConstraint = createBounds
			insertChild(createDecorationNode => [
				type = "BorderItemLabel"
				styles += createShapeStyle
				layoutConstraint = createLocation
			])
		])
		result
	}

	def createFinalNode(FinalState finalState) {
		createNode => [
			type = "FinalState"
			element = finalState
			layoutConstraint = createBounds
			styles += createShapeStyle => [
				fontName = "Verdana"
				lineColor = 4210752
			]
		]
	}

	def createChoiceNode(Choice choice) {
		createNode => [
			type = "Choice"
			element = choice
			layoutConstraint = createBounds
			styles += createShapeStyle => [
				fontName = "Verdana"
				lineColor = 4210752
			]
		]
	}

	def createSynchNode(Synchronization sync) {
		createNode => [
			type = "Synchronization"
			element = sync
			layoutConstraint = createBounds
			styles += createShapeStyle => [
				fontName = "Verdana"
				lineColor = 4210752
			]
		]
	}

	def createNoteShape() {
		createShape => [
			type = "Note"
			fontName = "Verdana"
			fillColor = 13369343
			lineColor = 6737151
			lineWidth = 1
			layoutConstraint = createBounds
			styles += createTextStyle => []
			styles += createLineTypeStyle => []
			insertChild(createBasicDecorationNode => [
				type = "Description"
			])
		]
		
	}

	def createTransitionEdge(Transition transition) {
		createEdge => [
			type = "Transition"
			element = transition
			bendpoints = createRelativeBendpoints
			styles += createConnectorStyle => [
				routing = Routing.RECTILINEAR_LITERAL
				lineColor = 4210752
			]
			styles += createFontStyle => [
				fontName = "Verdana"
			]
		]
	}

}
