/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Axel Terfloth - itemis AG
 * 
 */
package com.yakindu.base.types.adapter

import org.eclipse.emf.common.notify.Adapter
import org.eclipse.emf.ecore.EObject

/**
 * Utility class to handle adapter assingment.
 * 
 * @author Axel Terfloth - inital contribution.
 * 
 */
class Adapters {
	
	def static protected <S extends Adapter, T extends EObject> T assignAdapter(T it, S adapter) {
		val existingAdapter = it?.eAdapters.filter(adapter.class).head

		if (existingAdapter !== null) {
			it.eAdapters.set(it.eAdapters.indexOf(existingAdapter), adapter)
		} else {
			it.eAdapters.add(adapter)
		}
		return it
	}
	
	def static protected <S extends Adapter, T extends EObject> T removeAdapter(T it, Class<? extends S> adapter) {
		val existingAdapter = it?.eAdapters.filter(adapter).head

		if (existingAdapter !== null) {
			it.eAdapters.remove(existingAdapter)
		}
		return it
	}
	
}