/**
 * Copyright (c) 2022-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.types.typesystem

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.annotations.TypeAnnotations
import org.eclipse.emf.ecore.EObject

/**
 * Concept to provide "value" property for events. This allows a simpler access and enables to access complex typed event payloadsx
 * 
 * TODO: This concept extends the type system and should be complete. Currently the creating of the 
 * meta feature is done in the GenericTypeSystem due to initialization constraints.
 * 
 * @author laszlo kovacs - Initial contribution
 * @author axel terfloth - refinement
 *
 */
class EventValueMetaFeature {

	@Inject
	ITypeSystem typeSystem

	protected extension TypesFactory = TypesFactory.eINSTANCE
	
	@Inject protected extension TypeAnnotations
	@Inject protected extension TypeBuilder

	def eventValueProperty() {
		return typeSystem
					.getMetaFeatures(Event)
					.filter[ name == GenericTypeSystem.EVENT_VALUE_PROPERTY ]
					.head
	}
	
	def dispatch isEventValueProperty(Property it){
		name == GenericTypeSystem.EVENT_VALUE_PROPERTY 
		&& hasBuiltInTypeAnnotation
	}
	
	def dispatch isEventValueProperty(EObject it){false}
}
