/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sct.generator.scxml

import com.google.common.collect.Sets
import com.google.inject.Inject
import com.yakindu.sct.generator.scxml.modifications.IModification
import java.util.Set
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.util.EcoreUtil
import org.eclipse.emf.transaction.RunnableWithResult
import org.eclipse.emf.transaction.util.TransactionUtil
import com.yakindu.sct.model.sgraph.Statechart

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class SCXMLModelModifications {

	@Inject
	Set<IModification> modifications = Sets.newHashSet();

	def Statechart modifyInternal(Statechart it, Resource targetResource) {
		val scCopy = EcoreUtil.copy(it)
		if (targetResource !== null) {
			targetResource.contents += scCopy
		}
		modifications.forEach[mod|mod.modify(scCopy)]
		return scCopy
	}

	def Statechart modify(Statechart statechart, Resource targetResource) {
		val editingDomain = TransactionUtil.getEditingDomain(statechart);
		if (editingDomain === null) {
			return statechart.modifyInternal(targetResource)
		}
		val runnable = new RunnableWithResult.Impl<Statechart>() {
			override run() {
				result = statechart.modifyInternal(targetResource)
			}
		}
		editingDomain.runExclusive(runnable);
		return runnable.result
	}

	def Statechart modify(Statechart statechart) {
		modify(statechart, null)
	}

}
