/** 
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sct.generator.scxml.modifications

import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.expressions.expressions.ReactionTrigger
import com.yakindu.base.types.Expression
import com.yakindu.sct.model.sgraph.SGraphFactory
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.Synchronization
import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.sgraph.Vertex
import com.yakindu.sct.model.sgraph.util.SGgraphUtil
import com.yakindu.sct.model.stext.stext.StextFactory

import static extension org.eclipse.emf.ecore.util.EcoreUtil.*

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class SynchronizationModification implements IModification {

	extension SGraphFactory = SGraphFactory.eINSTANCE
	extension StextFactory = StextFactory.eINSTANCE
	extension ExpressionsFactory = ExpressionsFactory.eINSTANCE

	override void modify(Statechart statechart) {
		val allSyncs = statechart.eAllContents.filter(Synchronization).filter[join].toList
		val incomingTransitions = allSyncs.map[incomingTransitions].flatten
		allSyncs.forEach[createAnchestorTransition]
		incomingTransitions.forEach[remove]
		allSyncs.toList.forEach[remove]
	}

	def protected void createAnchestorTransition(Synchronization sync) {
		if (sync.isJoin) {
			val vertices = sync.incomingTransitions.map[source].filter(Vertex)
			val commonAnchestor = vertices.map[SGgraphUtil.collectAncestors(it, newArrayList)].reduce[
				val list = newArrayList
				list.addAll($0)
				list.retainAll($1)
				list
			].reverse.head as Vertex
			val transition = createTransition => [
				trigger = createReactionTrigger => [
					val evTriggers = sync.incomingTransitions.map[trigger].filter(ReactionTrigger).map[triggers].flatten
					evTriggers.forEach[evT|triggers += evT.copy]
					guard = createGuard => [
						expression = combine(sync.incomingTransitions.transitionGuard, vertices.isActiveGuard())
					]
				]
				target = sync.outgoingTransitions.head.target
			]
			commonAnchestor.outgoingTransitions += transition
		}
	}

	def protected Expression isActiveGuard(Iterable<Vertex> vertices) {
		vertices.filter(State).map[s|createActiveStateReferenceExpression => [value = s]].filter(Expression).combine
	}

	def protected Expression transitionGuard(Iterable<Transition> incomingTransitions) {
		incomingTransitions.map[trigger].filter(ReactionTrigger).map[guard].filterNull.map[expression].combine

	}

	def Expression combine(Iterable<Expression> expressions) {
		expressions.reduce[p1, p2|p1.combine(p2)]
	}

	def Expression combine(Expression p1, Expression p2) {
		if (p1 === null)
			return p2
		if (p2 === null)
			return p1
		createLogicalAndExpression => [leftOperand = p1 rightOperand = p2]
	}

	def protected isJoin(Synchronization it) {
		(incomingTransitions.size > 1) && (outgoingTransitions.size == 1)
	}
}
