/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.core.artifacts

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.artifacts.IContent
import com.itemis.create.base.generator.core.artifacts.IGenArtifact
import com.yakindu.base.types.Package

/**
 * Defines the artifact type of a general source file and implements the proper interface for integration into the CREATE code generator infrastructure.
 * 
 * @author Axel Terfloth
 */
class SourceFile implements IContent, IGenArtifact {
	
	@Inject protected extension GeneratorAssignment
	
	
	protected Package compilationUnit
	

	def Package getCompilationUnit() {
		compilationUnit
	}

	def setCompilationUnit(Package cu) {
		compilationUnit = cu
	}
	
	def String fileName(Package it) '''«it.name».«fileExtension»'''
	
	def String fileName() { compilationUnit.fileName }
	
	def String fileExtension() '''source'''
	
	override content() {
		'''
			«compilationUnit.definitionCode»
			
		'''
	}
	
	
}
