/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.core.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.yakindu.base.types.Package
import com.yakindu.base.types.TypeBuilder

/**
 * Defines the code model concept of name spaces. A name space contains one or more declarations which are member of that name space. 
 * A name space model element is a Package which is annotated as name space. 
 * This concept definition provides a builder to create a definition of namespaces subclasses should override namespaceGenerator() 
 * 
 * @author Axel Terfloth
 */
class Namespace {
	
	@Inject protected extension TypeBuilder
	@Inject protected extension GeneratorAssignment
	
	public static final String NAMESPACE_ANNOTATION_NAME = "__namespace__"
	
	def _namespace() {
		_package => [
			it._namespace
		]
	}
	
	def _namespace(Package it) {
		_annotate(NAMESPACE_ANNOTATION_NAME)
		generateDefinitionWith[namespaceGenerator]
	}
	
	def isNamespace(Package it) {
		getAnnotationOfType(namespaceAnnotationName) !== null
	}
	
	/** 
	 * Subclasses may overwrite in order to use a different annotation.
	 */
	def namespaceAnnotationName() {
		NAMESPACE_ANNOTATION_NAME
	}
	
	/** 
	 * Subclasses should override this method for target language specific code generation.
	 */
	def protected namespaceGenerator(Package it) '''
		// no generator specified for namespace «name»
	'''
}
