/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.core.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.TypeBuilder

/**
 * Constructed types should be annotated with this annotation (if required) to prevent any transformation side effects
 * 
 * @author lkovacs - Initial contribution
 */
@Singleton
class InternallyDefinedTypeAnnotation {
	
	@Inject protected extension TypeBuilder
	
	
	public static String __INTERNALLY_DEFINED_TYPE__ = "__internal_statemachine_variable__"
	
	def isInternallyDefinedType(AnnotatableElement it){
		if(getAnnotationOfType(__INTERNALLY_DEFINED_TYPE__) !== null) return true
		else false
	}
	
	def <T extends AnnotatableElement> T _internallyDefinedType(T e) {
		e._annotate(__INTERNALLY_DEFINED_TYPE__)
	}
}