/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.scoping

import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.types.Annotation
import com.yakindu.base.types.Argument
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Operation
import com.yakindu.base.types.TypedDeclaration
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class ExpressionsScopeProvider extends AbstractDeclarativeScopeProvider {

	def scope_Argument_parameter(Argument object, EReference ref) {
		var parameters = object?.eContainer?.operation?.parameters
		var properties = object.eContainer.gatherParentTypeProperties
		return if (parameters !== null)
			Scopes.scopeFor(parameters)
		else if (properties !== null)
			Scopes.scopeFor(properties)
		else
			IScope.NULLSCOPE;
	}

	def scope_Argument_parameter(InitializationExpression object, EReference ref) {
		var properties = object.eContainer.gatherParentTypeProperties
		Scopes.scopeFor(properties)
	}

	def scope_ElementReferenceExpression_reference(InitializationExpression object, EReference ref) {
		val compType = (object.eContainer as Argument).parameter.type
		if(compType instanceof ComplexType)
			Scopes.scopeFor(compType.getComplTypeProps)
		else
			Scopes.scopeFor(#[(object.eContainer as Argument).parameter])
	}

	def scope_ElementReferenceExpression_reference(Argument object, EReference ref) {
		val compType = (object.parameter.type as ComplexType)
		if(compType instanceof ComplexType)
			Scopes.scopeFor(compType.getComplTypeProps)
		else
			Scopes.scopeFor(#[(object.eContainer as Argument).parameter])
	}

	def scope_InitializationExpression(Argument object, EReference ref) {
		var parameters = object?.eContainer?.operation?.parameters
		return if(parameters !== null) Scopes.scopeFor(parameters) else IScope.NULLSCOPE;
	}

	def scope_Argument_parameter(Annotation object, EReference ref) {
		var parameters = object?.operation?.parameters
		return if(parameters !== null) Scopes.scopeFor(parameters) else IScope.NULLSCOPE;
	}

	def scope_Argument_parameter(ElementReferenceExpression exp, EReference ref) {
		var parameters = exp?.operation?.parameters
		return if(parameters !== null) Scopes.scopeFor(parameters) else IScope.NULLSCOPE;
	}

	def scope_Argument_parameter(FeatureCall fc, EReference ref) {
		var parameters = fc?.operation?.parameters
		return if(parameters !== null) Scopes.scopeFor(parameters) else IScope.NULLSCOPE;
	}

	def dispatch getOperation(ElementReferenceExpression it) {
		return if (reference instanceof Operation)
			reference as Operation
		else
			null
	}

	def dispatch getOperation(FeatureCall it) {
		return if (feature instanceof Operation)
			feature as Operation
		else
			null
	}

	def dispatch getOperation(Annotation op) {
		op.type
	}

	def dispatch getOperation(EObject object) {
	}

	def dispatch List<TypedDeclaration> gatherParentTypeProperties(Operation it) {
		val props = newArrayList
		parameters.forEach [ p |
			if (p.type instanceof ComplexType)
				props += (p.type as ComplexType).getComplTypeProps
			else
				props += p
		]
		props
	}

	def dispatch List<TypedDeclaration> gatherParentTypeProperties(TypedDeclaration it) {
		if (type instanceof ComplexType)
			return (type as ComplexType).getComplTypeProps
		else
			return #[it]
	}

	def dispatch List<TypedDeclaration> gatherParentTypeProperties(FeatureCall it) {
		feature.gatherParentTypeProperties
	}

	def dispatch List<TypedDeclaration> gatherParentTypeProperties(ElementReferenceExpression it) {
		reference.gatherParentTypeProperties
	}

	def dispatch List<TypedDeclaration> gatherParentTypeProperties(EventRaisingExpression it) {
		event.gatherParentTypeProperties
	}

	def dispatch List<TypedDeclaration> gatherParentTypeProperties(InitializationExpression parent) {
		parent.eContainer.gatherParentTypeProperties
	}

	def dispatch List<TypedDeclaration> gatherParentTypeProperties(Argument parent) {
		if (parent.parameter !== null) {
			if (parent.parameter.type instanceof ComplexType)
				return (parent.parameter.type as ComplexType).features.filter(TypedDeclaration).toList
			else
				return #[parent.parameter]
		}
		else if(parent.eContainer instanceof InitializationExpression)
			parent.eContainer.gatherParentTypeProperties.get((parent.eContainer as InitializationExpression).arguments.indexOf(parent)).type.getComplTypeProps
		else
			parent.eContainer.gatherParentTypeProperties
	}

	def dispatch List<TypedDeclaration> gatherParentTypeProperties(AssignmentExpression parent) {
		parent.varRef.gatherParentTypeProperties
	}

	def dispatch List<TypedDeclaration> gatherParentTypeProperties(EObject parent) {}

	def dispatch List<TypedDeclaration> getComplTypeProps(ComplexType it) {
		val props = newArrayList
		features.filter(TypedDeclaration).forEach [ f |
				props += f
		]
		props
	}

	def dispatch List<TypedDeclaration> getComplTypeProps(EObject it) {}

}
