/**
 *   Copyright (c) 2014-2022 committers of itemis CREATE.
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *   
 *   Contributors:
 *   	Markus Mühlbrandt - Initial contribution and API
 */

package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.TimeEventSpec
import com.yakindu.sct.generator.c.CNamingService
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgraph.RegularState
import java.util.Arrays

import static com.yakindu.sct.generator.cpp.CppKeywords.*
import com.google.inject.Singleton

@Singleton
class CppNamingService extends CNamingService {

	@Inject extension SExecExtensions

	override protected prefix(Step it, char separator) {
		switch (it) {
			case isCheckFunction: "check"
			case isEntryAction: "enact"
			case isExitAction: "exact"
			case isEffect: "effect"
			case isEnterSequence: "enseq"
			case isDeepEnterSequence: "dhenseq"
			case isShallowEnterSequence: "shenseq"
			case isExitSequence: "exseq"
			case isReactSequence: "react"
			default: ""
		}
	}

	override protected prefix(ExecutionState it, char separator) {
		""
	}

	override protected prefix(RegularState it, char separator) {
		""
	}

	override protected prefix(TimeEventSpec it, NamedElement element, char separator) {
		""
	}

	override isKeyword(String name) {
		var isKeyword = !Arrays::asList(CPP_KEYWORDS).findFirst[it.equalsIgnoreCase(name)].nullOrEmpty
		return isKeyword || super.isKeyword(name)
	}
	
	override protected dispatch String elementName(Method it) {
		name
	}
	
}
