/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.PrimitiveType
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.sct.generator.c.types.CTypeSystemAccess
import com.yakindu.sct.generator.cpp.types.CppTypes

import static com.yakindu.sct.generator.c.typesystem.CTypeSystem.BOOL
import org.eclipse.xtext.EcoreUtil2
import com.yakindu.sct.model.sexec.ExecutionFlow

/**
 * 
 * @author aterfloth
 * 
 */
class CppTypeSystemAccess extends CTypeSystemAccess {
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension CppTypes
	
	override printStateEnumType(EnumerationType type) {
		type.getOriginStatechart.module + "::" + type.name
	}
	
	override printStatechartType(ComplexType type) {
		val namespace = type.getOriginStatechart.statechartNamespace
		namespace.join("", "::", "::", [it]) + type.getOriginStatechart.module + "*"

	}

	override protected targetLanguageSpecifier(TypeSpecifier tspec, String typeLiteral) {
		var typeSpecLiteral = typeLiteral
		
		if (tspec !== null && !tspec.typeArguments.isEmpty) {
			typeSpecLiteral +=
				(tspec.typeArguments.join('<', ',', '>', [targetLanguageSpecifier])).replaceAll('>>', '> >')
		}
		
		return typeSpecLiteral
	}
	
	override protected dispatch String targetLanguageName(PrimitiveType it) {
		switch (it) {
			case it.isSame(getType(BOOL)): sc_bool.fqName
			case it.isVoid :   sc_void.name
			case it.isInteger: sc_integer.fqName
			case it.isReal:   sc_real.fqName
			case it.isBoolean: sc_bool.fqName
			case it.isStringLiteral: sc_string.fqName
			case it.isString:  sc_string.fqName
			default: it.asLiteral
		}
	}
	
	override dispatch String targetLanguageName(Type it, TypeSpecifier tspec) {
		switch (it) {
			case isBuiltInType: tspec.printBuiltInType
			default: tspec.targetLanguageSpecifier(it.targetLanguageName())
		}
	}
	
	override protected dispatch String targetLanguageName(ComplexType it) {
		switch (it) {
			case isInternalStatemachineType : printInternalStatechartType
			case isStatemachineOwnedType : name
			default: super._targetLanguageName(it)
		}	
	}
	
	def protected isStatemachineOwnedType(ComplexType it) {
		EcoreUtil2.getContainerOfType(it, ExecutionFlow) !== null
	}
	
	protected def printInternalStatechartType(ComplexType type) {
		"sc::" + 
			if(type.superTypes.nullOrEmpty) {
				type.toString + "Interface*" 
			} else {
				type.toString.replace("Statemachine", "Interface*") 
			}
	}
	
	override pointerSymbol(TypeSpecifier it) {
		"*"
	}
	
}