/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Package
import com.yakindu.base.types.TypedElement
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.annotations.TypeAnnotations
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.base.types.inferrer.ITypeSystemInferrer.InferenceResult
import com.yakindu.sct.generator.c.types.CTypeAnnotations
import com.yakindu.sct.generator.c.types.CTypeSystemAccess
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.concepts.LoggerTypeLibrary
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import org.eclipse.emf.ecore.EObject

/**
 * Helper class to decide which kind of separator ('->', '::', '.') needs to be printed for a feature call.
 */
class FeatureCallSeparator {
	
	@Inject protected extension ExpressionExtensions
	@Inject extension OriginTracing
	@Inject extension CppNaming
	@Inject extension TypeAnnotations
	@Inject extension StatechartUtil
	@Inject extension protected StatemachineTypes
	@Inject protected extension CTypeAnnotations
	@Inject protected extension CTypeSystemAccess typeSystemAccess
	@Inject protected extension ITypeSystemInferrer
	@Inject protected extension LoggerTypeLibrary
	
	// Treat null infer result gracefully, mainly in favor of domain test
	def dispatch CharSequence callSep(Void owner) '''.'''
	def dispatch CharSequence callSep(EObject owner) '''.'''
	def dispatch CharSequence callSep(Package owner) '''::''' // namespaces are separated by ::
	def dispatch CharSequence callSep(ComplexType owner) {
		if(owner.isCStruct || owner.eContainer === getLoggerPackage){
			if(owner.isReferenceTypeAnnotated)
				'''->'''
			else
				'''.'''
		} else
			'''::'''
	} // classes are separated by ::
	def dispatch CharSequence callSep(ArgumentExpression it) { 
		if(pointerForStatechart) 
			'''->''' 
		else if ((featureOrReference instanceof InterfaceScope) 
				|| (featureOrReference instanceof ComplexType )
				|| (featureOrReference instanceof Package))
			'''«it.featureOrReference.callSep»'''
			
		else 
			it.infer.callSep
	}
	def dispatch CharSequence callSep(InterfaceScope it) { ifaceAcces }
	def dispatch CharSequence callSep(TypedElement it) { type.originCallSep}
	def dispatch CharSequence callSep(InferenceResult it) { type.originCallSep}
	
	def originCallSep(EObject it){
		switch (it) {
			case originTraces.exists[it instanceof InterfaceScope] : ifaceAcces
			case isOriginStatechart, 
			case isInternalStatemachineType, 
			ComplexType case typeSystemAccess.isReferenceType(it) || isPointerType : '''->'''
			default: '''.'''
		}
	}
	
	def dispatch pointerForStatechart(ArgumentExpression it){
		false
	}
	
	def dispatch pointerForStatechart(FeatureCall it){
		if(owner.featureOrReference instanceof VariableDefinition){
			val varDef = owner.featureOrReference as VariableDefinition
			if(varDef?.typeSpecifier.typeArguments !== null && varDef.typeSpecifier.typeArguments.head?.getType.isOriginStatechart)
				return true
		}
		false
	}
}