/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.Call
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.CheckRef
import com.yakindu.sct.model.sexec.EnterState
import com.yakindu.sct.model.sexec.Execution
import com.yakindu.sct.model.sexec.ExitState
import com.yakindu.sct.model.sexec.HistoryEntry
import com.yakindu.sct.model.sexec.If
import com.yakindu.sct.model.sexec.LocalVariableDefinition
import com.yakindu.sct.model.sexec.SaveHistory
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sexec.Sequence
import com.yakindu.sct.model.sexec.StateSwitch
import com.yakindu.sct.model.sexec.Statement
import com.yakindu.sct.model.sexec.TraceStateEntered
import com.yakindu.sct.model.sexec.TraceStateExited
import com.yakindu.sct.model.sexec.UnscheduleTimeEvent
import com.yakindu.sct.model.sexec.concepts.MicroStep
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.util.SgraphExtensions

import static com.yakindu.sct.generator.c.CGeneratorConstants.*

class FlowCode extends com.yakindu.sct.generator.c.FlowCode {
	
	@Inject protected extension CppNaming naming
	@Inject protected extension CppFileNaming
	@Inject protected extension CppExpressionsGenerator expressions
	@Inject protected extension SExecExtensions
	@Inject protected extension INamingService
	@Inject protected extension GenmodelEntries
	@Inject protected extension Literals
	@Inject protected extension CppTypes
	@Inject protected extension SgraphExtensions
	
	@Inject GeneratorEntry entry
	
	override dispatch CharSequence code(SaveHistory it) '''
		«stepComment»
		«HISTORYVECTOR»[«region.historyVector.offset»] = «STATEVECTOR»[«region.stateVector.offset»];
	'''
	
	override dispatch CharSequence code(HistoryEntry it) '''
		«stepComment»
		if («HISTORYVECTOR»[«region.historyVector.offset»] != «null_state»)
		{
			«historyStep.code»
		} «IF initialStep !== null»else
		{
			«initialStep.code»
		} «ENDIF»
	'''

	override dispatch CharSequence code(StateSwitch it) '''
		«stepComment»
		«IF historyRegion !== null»
			switch(«HISTORYVECTOR»[ «historyRegion.historyVector.offset» ])
			{
		«ELSE»
			switch(«STATEVECTOR»[ «stateConfigurationIdx» ])
			{
		«ENDIF»
			«FOR caseid : cases»
				case «caseid.state.stateName» :
				{
					«IF caseid.step !== null»«caseid.step.code»«ENDIF»
					break;
				}
			«ENDFOR»
			default:
				/* do nothing */
				break;
		}
	'''
	
	def dispatch CharSequence code(TraceStateEntered it) '''
		«IF entry.tracingEnterState»
		if(«flow.tracingInstance» != «NULL_LITERAL») {
			«flow.tracingInstance»->«flow.enterStateTracingFctID»(«flow.module»::«it.state.stateName»);
		}
		«ENDIF»
	'''
	
	def dispatch CharSequence code(TraceStateExited it) '''
		«IF entry.tracingExitState»
		if(«flow.tracingInstance» != «NULL_LITERAL») {
			«flow.tracingInstance»->«flow.exitStateTracingFctID»(«flow.module»::«it.state.stateName»);
		}
		«ENDIF»
	'''

	override dispatch CharSequence code(ScheduleTimeEvent it) '''
		«stepComment»
		«timerInstance»->«flow.setTimerFctID»(this, («sc_eventid.fqName»)(&«timeEventsInstance»[«timeEvent.indexOf»]), «timeValue.code», «IF timeEvent.periodic»true«ELSE»false«ENDIF»);
	'''

	override dispatch CharSequence code(UnscheduleTimeEvent it) '''
		«stepComment»
		«timerInstance»->«flow.unsetTimerFctID»(this, («sc_eventid.fqName»)(&«timeEventsInstance»[«timeEvent.indexOf»]));
	'''
	
	override dispatch CharSequence code(Execution it) 
		'''«statement.code»;'''
	
	override dispatch CharSequence code(Call it) 
		'''«step.shortName»();'''
	
	override dispatch CharSequence code(Sequence it) {
		if (it.isStateMachineConcept) 
			it.flow.stateMachineConceptCode(it)	
		else '''
			«IF !steps.nullOrEmpty»«stepComment»«ENDIF»
			«FOR s : steps»
				«s.code»
			«ENDFOR»
		'''
	}
	
	override dispatch CharSequence code(Check it) 
		'''«IF condition !== null»«condition.code»«ELSE»true«ENDIF»'''
	
	override dispatch CharSequence code(CheckRef it) 
		'''«IF check !== null»«check.shortName»()«ELSE»true«ENDIF»'''
		
    override dispatch CharSequence code(If it) '''
		«stepComment»
		if («check.code»)
		{ 
			«thenStep.code»
		} «IF (elseStep !== null)» else
		{
			«elseStep.code»
		}
		«ENDIF»
	'''
	
	override dispatch CharSequence code(EnterState it) {
		val firstPos = state.statevectorFirstPosition
		val lastPos = state.statevectorLastPosition
		'''
			«FOR i: firstPos .. lastPos»
				«STATEVECTOR»[«i»] = «state.stateName»;
			«ENDFOR»
			«IF flow.needsStateVectorPosition»
				«MicroStep.STATE_VECTOR_POSITION» = «firstPos»;
			«ENDIF»
			«flow._stateChanged.code»
		'''
	}

	override dispatch CharSequence code(ExitState it) {
		val parentState = it.state.sourceElement.parentState
		val stateName = if ( parentState !== null ) parentState.stateName else null_state
		val firstPos = state.statevectorFirstPosition
		val lastPos = state.statevectorLastPosition
		
		'''
		«FOR i: firstPos .. lastPos»
			«STATEVECTOR»[«i»] = «stateName»;
		«ENDFOR»
		«IF flow.needsStateVectorPosition»
			«MicroStep.STATE_VECTOR_POSITION» = «lastPos»;
		«ENDIF»
		'''
	}
	
	override dispatch CharSequence code(LocalVariableDefinition it) '''
		«variable.typeSpecifier.targetLanguageName» «variable.name»«IF initialValue !== null» = «initialValue.code»«ENDIF»;
	'''
	
	override dispatch CharSequence code(Statement it) '''
		«expression.statement»
	'''
}