/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.concepts

import com.google.inject.Inject
import com.yakindu.base.types.TypeBuilder
import com.google.inject.Singleton
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.Type

/**
 * Defines the code model level concept of a C++ reference type. 
 * This is not yet intended for C++ type system implementation.
 * 
 * @author axel terfloth
 */
@Singleton
class CppReference {
	
	@Inject protected extension TypeBuilder
	
	def create it : _complexType cppReferenceType() {
		name = "__cpp_refernce__"
		val T = _typeParam("T")
		it.typeParameters += T
	}
	
	def isCppReferenceType(TypeSpecifier it) {
		it.type.isCppReferenceType
	}
	
	def isCppReferenceType(Type it) {
		it === cppReferenceType
	}
	
}