/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.eventdriven

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.ShadowMemberScope
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*

/**
 * @author René Beckmann - Initial contribution and API
 */
class EventNaming extends com.yakindu.sct.generator.c.extensions.EventNaming {
	
	@Inject extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject extension SExecExtensions
	@Inject extension INamingService
	@Inject extension ShadowMemberScope
	
	override eventEnumName(ExecutionFlow it) {
		'''«module»EventName'''
	}
	
	override getTimedEventNameFctID(ExecutionFlow it) {
		'''getTimedEventName'''
	}
	
	def eventClassName(Event it) {
		'''«SCT_EVENT»_«scope.interfaceName»_«it.name.asIdentifier»'''
	}
	
	def timedEventClassName() {
		'''«TIMED_SCT_EVENT»'''
	}
	
	def eventNamespaceName(ExecutionFlow it) {
		'''«name.asIdentifier.toLowerCase»_events'''
	}
	
	override internalQueue() {
		"internalEventQueue"
	}
	
	override nextEventFctID(ExecutionFlow it) {
		NEXT_EVENT
	}
	
	override dispatchEventFctID(ExecutionFlow it) {
		"dispatch_event"
	}
	
	def dispatchEventFctIDbyScope(ExecutionFlow it, Scope scope) {
		switch scope {
			InterfaceScope case scope.name === null: return "iface_" + dispatchEventFctID
			InterfaceScope case scope.name !== null: return dispatchEventFctID
			InternalScope case scope.isShadowMemberScope: "shadow_" + dispatchEventFctID
			InternalScope case !scope.isShadowMemberScope: "internal_" + dispatchEventFctID
		}
	}
	
	override inEventQueue() {
		"inEventQueue"
	}
	
	override addToQueueFctID(ExecutionFlow it) {
		super.addToQueueFctID(it)
	}
	
	override addToQueueValueFctID(ExecutionFlow it) {
		super.addToQueueValueFctID(it)
	}
}