/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

class CycleBasedInterface implements IContentTemplate<ExecutionFlow> {
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension GenmodelEntriesExtension
	
	override content(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#ifndef «cycleBasedModule.define»_H_
		#define «cycleBasedModule.define»_H_
		
		#include "«statemachineModule.h»"
		
		namespace sc {
		
		/*! \file
		Interface for cycle-based state machines.
		*/
		class «cycleBasedInterface» : public sc::«statemachineInterface»
		{
			public:
			
				virtual ~«cycleBasedInterface»() = 0;
			
				/*! Start a run-to-completion cycle.
				*/
				virtual void «runCycleFctID»() = 0;
		};
		
		inline «cycleBasedInterface»::~«cycleBasedInterface»() {}
		
		} /* namespace sc */
		
		#endif /* «cycleBasedModule.define»_H_ */
		'''
	}
	
}