/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * Baseline implementation for the logger. The loggers responsibility is to print and store the statechart provided logs.
 * 
 * @author laszlo kovacs - Initial contribution
 */
class LoggerHeader implements IContentTemplate<ExecutionFlow>{
	@Inject extension GenmodelEntriesExtension
	@Inject extension CppFileNaming
	@Inject protected extension CppPointers
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#ifndef «loggerModule.define»_H_
		#define «loggerModule.define»_H_
		
		#include "«(typesModule.h).relativeTo(loggerModule.h)»"
		#include <deque>
		#include <iostream>
		#include <stdarg.h>
		
		namespace sc {
		namespace logging {
			class Logger
				{
				private:
					std::deque<std::string> *log;
				public:
					Logger(std::deque<std::string> *_log
						) : log(_log)
					{
					}
					virtual ~Logger() {}
					virtual void write(std::string text, ...) {
				
						char *buf;
						va_list ap;
				
						va_start(ap, text);
						const char* fmt = text.c_str();
						vasprintf(&buf, fmt, ap);
						va_end(ap);
				
						std::string str(buf);
						
						free(buf);
						
						std::cout << str << std::endl;
						
						log->emplace_back(str);
					}
				};
		} /* namespace sc::logging */
		} /* namespace sc */
		#endif // «loggerModule.define»_H_
		'''	
		}
}