/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * 	Kovacs Laszlo - itemis AG
 */
package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry

class MetaHeader implements IContentTemplate<ExecutionFlow> {
	@Inject extension GenmodelEntriesExtension
	@Inject extension CppNaming
	@Inject extension CppFileNaming
	@Inject extension CppTypes
	@Inject extension SExecExtensions
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»

		#ifndef «flow.module.define»_META_H_
		#define «flow.module.define»_META_H_

		#include "«(typesModule.h).relativeTo(flow.metaModule.h)»"
		
		namespace «flow.module.define»Meta {
		
		const «sc_ushort.name» «flow.metaFeaturesProperty»Size = «flow.scopes.map[it | it.eventAndVariableDefinitions].flatten.size + 1»;
		extern const «sc_string.name» «flow.metaFeaturesProperty»[«flow.metaFeaturesProperty»Size];
		
		const «sc_ushort.name» «flow.metaStatesProperty»Size = «flow.states.size +1»;
		extern const «sc_string.name» «flow.metaStatesProperty»[«flow.metaStatesProperty»Size];
		
		} // namespace «flow.module.define»Meta
		

		#endif // «flow.module.define»_META_H_
		'''
	}
	
	def protected removePrefix(String s){
		return s.substring(s.indexOf(".")+1)
	}
}