/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * 
 * @author laszlo kovacs - Initial contribution
 */
class SubMachineContextInterface implements IContentTemplate<ExecutionFlow> {
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension GenmodelEntriesExtension
	
	override content(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#ifndef «subMachineContextModule.define»_H_
		#define «subMachineContextModule.define»_H_
		
		namespace sc {
		
		/*! \file
		Interface for state machine context.
		*/
		class «submachineContextInterface»
		{
			public:
			
				virtual ~«submachineContextInterface»() = 0;
								
				/*! Signal from the sub-childmachine to indicate that it received an event.
				*/
				virtual void «eventRaisedID»() const = 0;
		};
		
		inline «submachineContextInterface»::~«submachineContextInterface»() {}
		
		} /* namespace sc */
		
		#endif /* «subMachineContextModule.define»_H_ */
		'''
	}
	
}