/**
 * Copyright (c) 2020-2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.providers

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Event
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeAlias
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.cpp.CppExpressionsGenerator
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.FlowCode
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.providers.eventdriven.StatechartEventImpl
import com.yakindu.sct.generator.cpp.submodules.InterfaceFunctions
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.concepts.ExecutionGuard
import com.yakindu.sct.model.sexec.concepts.SubMachine
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.StatechartScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.List

import static com.yakindu.sct.generator.c.CGeneratorConstants.*

class ConstructorProvider implements ISourceFragment {

	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension CppSpecifiers
	@Inject protected extension SExecExtensions
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension INamingService
	@Inject protected extension ShadowEventExtensions
	@Inject protected GeneratorEntry entry
	@Inject protected extension ITypeValueProvider
	@Inject protected extension StatechartUtil
	@Inject protected extension EventProcessing
	@Inject protected extension ExecutionGuard
	@Inject protected extension FlowCode
	@Inject protected extension CppExpressionsGenerator
	@Inject protected extension GeneratorPredicate
	@Inject protected extension InterfaceFunctions
	@Inject protected extension StatemachineClass 
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension StatechartEventImpl
	
	@Inject protected extension SubMachine

	@Inject protected extension CppTypes
	@Inject protected extension Literals

	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		'''
			«constructorDefinition»
			
			«destructorDefinition»
			«FOR iface : namedInterfaces.filter(i | i.notEmptyClass)»
			
			«it.ifaceConstructorDefintion(iface)»
			«ENDFOR»
		'''
	}

	def ifaceConstructorDefintion(ExecutionFlow it, StatechartScope iface) {
		val initList = initialisationList(iface)
		'''
			«module»::«iface.interfaceName»::«iface.interfaceName»(«module»* «parentArgument»)«iface.propertyThrowsException» :
				«initList.generate»
			{
				«constructorBody(iface)»
			}
		'''
	}

	def constructorDefinition(ExecutionFlow it) {
		val initList = initialisationList
		'''
			«module»::«module»()«propertyThrowsException» :
				«initList.generate»
			{
				«constructorBody(it)»
			}
		'''
	}

	def protected initialisationList(ExecutionFlow it) {
		val List<Pair<String, String>> toInit = newArrayList
		interfaces.filter[!isNamedScope].forEach [ s |
			s.declarations.forEach [ d |
				if (d instanceof EventDefinition) {
					if (!useOutEventGetters && !d.isOutEvent) {
						toInit.add(d)
					}
				} else {
					toInit.add(d)
				}
			]
		]
		shadowEvents.forEach[e|toInit.add(e.observer.toString, "this")]
		if(timed) toInit.add(timerInstance, NULL_LITERAL)
		if(entry.tracingUsed) toInit.add(tracingInstance, "0")
		namedInterfaces.filter(i | i.notEmptyClass).forEach [
			toInit.add(instance, NULL_LITERAL)
		]
		unnamedInterfacesAndInternal.filter[(hasOperations && !entry.useStaticOPC)].forEach [
			toInit.add(OCB_Instance, NULL_LITERAL)
		]
		properties.forEach[p|toInit.add(p.name.asIdentifier, p.provideValue)]
		toInit
	}

	def protected initialisationList(ExecutionFlow flow, StatechartScope it) {
		val List<Pair<String, String>> toInit = newArrayList
		declarations.forEach[d|toInit.add(d)]
		toInit.add('''«parentMember»''', '''«parentArgument»''')
		if (hasOperations && !entry.useStaticOPC) {
			toInit.add(OCB_Instance, NULL_LITERAL)
		}
		shadowEvents.forEach[toInit.add('''«observer»''', "this")]
		return toInit
	}

	def dispatch add(List<Pair<String, String>> toInit, Declaration it) {}

	def dispatch add(List<Pair<String, String>> toInit, VariableDefinition it) {
		if (!isConst) {
			toInit.add(localAccess.toString, provideValue)
		}
	}

	def dispatch add(List<Pair<String, String>> toInit, Event it) {
		if (useOutEventGetters || !isOutEvent) {
			toInit.add(localAccess.toString, "false")
			if (hasValue) {
				toInit.add(localValueAccess.toString, provideValue)
			}
		}
	}

	def dispatch provideValue(TypedDeclaration it) {
		return type.value
	}

	def dispatch provideValue(VariableDefinition it) {
		if (initialValue !== null) {
			return initialValue.code.toString
		}
		type.value
	}

	def dispatch value(Type it) {
		defaultValue.asLiteral
	}

	def dispatch value(EnumerationType it) {
		if (multiSM) {
			return enumerator.head.stateEnumerator
		}
		namespacePath + enumerator.head.access
	}

	def dispatch value(ComplexType it) {
		""
	}

	def dispatch String value(TypeAlias it) {
		type.value
	}

	protected def CharSequence constructorBody(ExecutionFlow it) '''
		«FOR iface : namedInterfaces.filter(i | i.notEmptyClass)»
			this->«iface.instance».«parentMember» = this;
		«ENDFOR»
		for («sc_ushort.fqName» state_vec_pos = 0; state_vec_pos < «orthogonalStatesConst»; ++state_vec_pos)
			«STATEVECTOR»[state_vec_pos] = «null_state»;
		
		«IF hasHistory»
			for («sc_ushort.fqName» state_vec_pos = 0; state_vec_pos < «historyStatesConst»; ++state_vec_pos)
				«HISTORYVECTOR»[state_vec_pos] = «null_state»;
			
		«ENDIF»
		«_clearInEvents.code»
		«_clearInternalEvents.code»
		«_swapIncomingEvents.code»
		«_swapInternalEvents.code»
		«_clearOutEvents.code»
	'''

	protected def CharSequence constructorBody(ExecutionFlow it, StatechartScope iface) '''
	'''

	def destructorDefinition(ExecutionFlow it) '''
		«module»::~«module»()
		{
			«deleteEventQueues»
			«FOR te : timeEvents»
			«timerInstance»->«unsetTimerFctID»(this, «te.indexOf»);
			«ENDFOR»
			«IF hasReferencedSubmachine»«FOR ctxMember : getSubmachineContextPoints»
			delete «ctxMember.name»;
			«ENDFOR»
			«ENDIF»
		}
	'''

	def protected generate(List<Pair<String, String>> values) {
		values.map['''«it.key»(«it.value»)'''].join(",\n")
	}

	def protected Pair<String, String> pair(String a, String b) {
		return new Pair<String, String>(a, b)
	}

	def protected void add(List<Pair<String, String>> l, String a, String b) {
		l.add(pair(a, b))
	}
}
