/**
 * Copyright (c) 2020-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.providers.classdecl

import com.google.inject.Inject
import com.google.inject.Provider
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.generator.c.submodules.StatechartTypes
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppObservables
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.providers.ISourceFragment
import com.yakindu.sct.generator.cpp.submodules.InterfaceFunctions
import com.yakindu.sct.generator.cpp.submodules.InternalFunctions
import com.yakindu.sct.generator.cpp.submodules.TimingFunctions
import com.yakindu.sct.generator.cpp.submodules.TracingFunctions
import com.yakindu.sct.generator.cpp.submodules.lifecycle.LifecycleFunctions
import com.yakindu.sct.generator.cpp.templates.ClassDeclaration
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sexec.transformation.StatechartExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.StatechartScope

import static com.yakindu.sct.generator.c.CGeneratorConstants.*
import static com.yakindu.sct.generator.c.types.CTypeSystemAccess.POINTER_TYPES
import static com.yakindu.sct.generator.cpp.CppSpecifiers.NO_EXCEPTION
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.ComplexType

class InnerClassesProvider implements ISourceFragment {
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension SExecExtensions
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension StatechartExtensions
	@Inject protected extension TypeBuilder
	
	@Inject protected GeneratorEntry entry
	@Inject protected Provider<ClassDeclaration> classDeclProvider
	
	@Inject protected extension InternalFunctions
	@Inject protected extension CppSpecifiers
	@Inject protected extension CppPointers
	@Inject protected extension InterfaceFunctions 
	@Inject protected extension TimingFunctions
	@Inject protected extension TracingFunctions
	@Inject protected extension LifecycleFunctions
	@Inject protected extension StatechartTypes
	@Inject protected extension INamingService
	@Inject protected extension ShadowEventExtensions
	@Inject protected extension CppObservables
	@Inject protected extension EventProcessing
	
	@Inject protected extension CppTypes
	
	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		methods.forEach[if( internalEventMethod ) _annotate(NO_EXCEPTION)]
		'''
			«IF (timed || hasOperationCallbacks || hasPointerDeclaration)»
				«copyConstructorDecl»
				«assignmentOperatorDecl»
			«ENDIF»
			
			«FOR s : interfaces.filter[!isNamedScope]»
				«s.createInternalMember»

			«ENDFOR»
			
			«statemachineFields»
			
			«FOR s : scopes.filter(InternalScope)»
				«s.declarations.filter(EventDefinition).map[functionPrototypes].join()»
			«ENDFOR»
			
			«prototypes»
		'''
	}
	
	def hasPointerDeclaration(ExecutionFlow it){
		scopes.exists[s | s.members.filter(TypedDeclaration).exists[m |
			m.type !== null && POINTER_TYPES.exists[ t | m.type.name == t]
		]]
	}
	
	def createInternalMember(StatechartScope it) '''
		«protectedInnerClassMembers»
		«shadowEvents.map[e | e.createObserverClass(classDeclProvider.get, it).generate ].join()»
		«shadowEvents.map[createObserver].join()»
	'''
	
	def protected copyConstructorDecl(ExecutionFlow it) {
		'''
			«module»(const «module» &rhs);
		'''
	}
	
	def protected assignmentOperatorDecl(ExecutionFlow it) {
		'''
			«module»& operator=(const «module»&);
		'''
	}
	
	def statemachineFields(ExecutionFlow it) '''
		«generateVectors»
		
		«IF timed»
			«sharedPtr»«scTimerNS»::«timerInterface»«pointerType» «timerInstance»;
			«sc_bool.fqName» «timeEventsInstance»[«timeEventsCountConst»];
		«ENDIF»
		
		«IF entry.tracingUsed»
			«scTraceNS»::«traceObserver»<«statesEnumType»>* «tracingInstance»;
		«ENDIF»
		
		«statesEnumType» «STATEVECTOR»[«orthogonalStatesConst»];
		
		«IF hasHistory»«statesEnumType» «HISTORYVECTOR»[«historyStatesConst»];«ENDIF»
		
		«generateInterfaces»
		
		«generateOCBInterfaces»
		
		«FOR t : features.filter(ComplexType)»
			typedef struct {
				«FOR f : t.features»
					«f.structMember»
				«ENDFOR»
			}«t.cType»;
		«ENDFOR»
		«generateProperties»
		
	'''
	
	def generateProperties(ExecutionFlow it)'''
		«FOR p : getProperties»
			«p.structMember»
		«ENDFOR»
	'''
	
	def generateInterfaces(ExecutionFlow it)'''
		«FOR s : namedInterfaces»
			«IF s.notEmptyClass»«s.interfaceName» «s.instance»;«ENDIF»
		«ENDFOR»
	'''
	
	def generateOCBInterfaces(ExecutionFlow it)'''
		«FOR s : getUnnamedInterfacesAndInternal»
			«IF s.hasOperations && !entry.useStaticOPC»«s.interfaceOCBName»* «s.OCB_Instance»;«ENDIF»
		«ENDFOR»
	'''
	
	def generateVectors(ExecutionFlow it)'''
		//! the maximum number of orthogonal states defines the dimension of the state configuration vector.
		static const «sc_ushort.fqName» «orthogonalStatesConst» «stateVector.size.assignValue»;
		«IF hasHistory»
		//! dimension of the state configuration vector for history states
		static const «sc_ushort.fqName» «historyStatesConst» «historyVector.size.assignValue»;«ENDIF»
	'''
}
