/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.providers.classdecl

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.providers.ISourceFragment
import com.yakindu.sct.generator.cpp.submodules.CheckFunction
import com.yakindu.sct.generator.cpp.submodules.InterfaceFunctions
import com.yakindu.sct.generator.cpp.submodules.InternalFunctions
import com.yakindu.sct.generator.cpp.submodules.TimingFunctions
import com.yakindu.sct.generator.cpp.submodules.TracingFunctions
import com.yakindu.sct.generator.cpp.submodules.lifecycle.LifecycleFunctions
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.transformation.StatechartExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * @author axel terfloth
 */
class PublicClassMemberProvider implements ISourceFragment {
	@Inject protected extension CppNaming
	@Inject protected extension CppSpecifiers
	@Inject protected extension SExecExtensions
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension StatechartExtensions
	
	@Inject protected GeneratorEntry entry
	
	@Inject protected extension InternalFunctions
	@Inject protected extension InterfaceFunctions
	@Inject protected extension TimingFunctions
	@Inject protected extension TracingFunctions
	@Inject protected extension LifecycleFunctions 
	@Inject protected extension CheckFunction

	@Inject protected extension CppTypes

	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		'''
		«stateDeclarations»
		
		«publicCodeModelMembers»
		
		«FOR s : it.scopes»«IF !s.members.nullOrEmpty»«s.createPublicScope»«ENDIF»«ENDFOR»
		
		«publicFunctionPrototypes»
		
		/*! Checks if the specified state is active (until 2.4.1 the used method for states was calles isActive()). */
		«sc_bool.fqName» «stateActiveFctID»(«statesEnumType» state) const«_noexcept»;
		
		«IF timed»
			//! number of time events used by the state machine.
			static const «sc_integer.fqName» «timeEventsCountConst» «timeEvents.size.assignValue»;
			
			//! number of time events that can be active at once.
			static const «sc_integer.fqName» «timeEventsCountparallelConst» «statechart.maxNumberOfParallelTimeEvents.assignValue»;
		«ENDIF»
		'''
	}
	
	def publicCodeModelMembers(ExecutionFlow it) ''''''
	
	def stateDeclarations(ExecutionFlow it) '''
		«statesEnumDecl»
					
		static const «sc_integer.fqName» «statesCountConst» = «states.size»;
	'''


	def statesEnumDecl(ExecutionFlow it) '''
		/*! Enumeration of all states */ 
		typedef enum
		{
			«null_state»,
			«FOR state : states SEPARATOR ","»
				«state.stateName»
			«ENDFOR»
		} «statesEnumType»;
	'''
	
	def protected publicFunctionPrototypes(ExecutionFlow it) '''
		«IStatemachineFunctions»
		
		«checkFunctionPrototype»

		«IF timed»
			«timedStatemachineFunctionPrototypes»
			
		«ENDIF»
		«IF entry.tracingUsed»
			«tracedStatemachineFunctions»
			
		«ENDIF»
	'''
	
}