/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.providers.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.eventdriven.EventNaming
import com.yakindu.sct.generator.cpp.providers.ISourceFragment
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.ImportScope
import com.yakindu.sct.model.stext.stext.StatechartScope

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*

class StatechartEventImpl implements ISourceFragment {

	@Inject protected extension EventQueue

	@Inject protected extension GeneratorPredicate
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension CppTypes
	@Inject protected extension CppSpecifiers
	@Inject protected extension SExecExtensions
	@Inject protected extension EventNaming eventNaming
	
	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		'''
		«IF needsNextEventFunction»
		«nextEventFunction»
		
		«ENDIF»
		«IF needsDispatchEventFunction»
		«generateInternalDispatchEventFunction»
		
		«generateInterfaceDispatchFunctions»
		
		«ENDIF»
		«IF needsTimedEventNameFunction»
		«generateTimedEventNameFunction»
		
		«ENDIF»
		'''
	}
	
	def getNextEventFunction(ExecutionFlow it) {
		val nE = "nextEvent"
		'''
		«SCT_EVENT»* «module»::«nextEventFctID»()«_noexcept»
		{
			«SCT_EVENT»* «nE» = 0;
			
			«IF requiresInternalEventQueue»
				if(!«internalQueue».empty()) {
					«nE» = «internalQueue».front();
					«internalQueue».pop_front();
				}
			«ENDIF»
			«IF requiresIncomingEventQueue»
				«IF requiresInternalEventQueue»else «ENDIF»if(!«inEventQueue».empty()) {
					«nE» = «inEventQueue».front();
					«inEventQueue».pop_front();
				}
			«ENDIF»
			
			return «nE»;
		}
		'''
	}
	
	def deleteEventQueues(ExecutionFlow it) {
		val nE = "nextEvent"
		'''
		«IF requiresInternalEventQueue»
		while (!«internalQueue».empty()) {
			«eventNamespaceName»::«SCT_EVENT»* «nE» = «internalQueue».front();
			«internalQueue».pop_front();
			delete «nE»;
		}
		«ENDIF»
		«IF requiresIncomingEventQueue»
		while (!«inEventQueue».empty()) {
			«eventNamespaceName»::«SCT_EVENT»* «nE» = «inEventQueue».front();
			«inEventQueue».pop_front();
			delete «nE»;
		}
		«ENDIF»
		'''
	}
	
	def generateTimedEventNameFunction(ExecutionFlow it) {
		val timeEvents = timeEvents
		'''
		«eventEnumName» «module»::«timedEventNameFctID»(«sc_eventid.fqName» evid)
		{
			«FOR timeEvent : timeEvents»
				if (evid == («sc_eventid.fqName»)(&«timeEventsInstance»[«timeEvents.indexOf(timeEvent)»])) {
					return «timeEvent.eventEnumMemberName»;
				}
			«ENDFOR»
			return «invalidEventEnumName»;
		}
		'''
	}
	
	def generateInterfaceDispatchFunctions(ExecutionFlow it) {
		'''
		«FOR s : statechartScopes»
		«generateInterfaceDispatchFunction(s)»
		«ENDFOR»
		'''
	}

	def dispatch generateInterfaceDispatchFunction(ExecutionFlow it, ImportScope s) {}

	def dispatch generateInterfaceDispatchFunction(ExecutionFlow it, Scope s) {
		val ev = "_event"
		'''
			«sc_bool.fqName» «module»::«s.scopedAccess»«dispatchEventFctIDbyScope(s)»(«SCT_EVENT» * «ev»)«_noexcept»
			{
				switch(«ev»->name)
				{
					«FOR e : s.queuedEventDefintions»
						case «e.eventEnumMemberName»:
						{
							«IF e.hasValue»
								«e.eventClassName» * e = static_cast<«e.eventClassName»*>(«ev»);
								if(e != 0) {
									internal_«e.asRaiser»(e->value);
									break;
								}
								delete «ev»;
								return false;
							«ELSE»
								internal_«e.asRaiser»();
								break;
							«ENDIF»
						}
					«ENDFOR»
					default:
						delete «ev»;
						return false;
				}
				delete «ev»;
				return true;
			}
			'''
	}

	def generateInternalDispatchEventFunction(ExecutionFlow it) {
		val ev = "_event"
		'''	
			«sc_bool.fqName» «module»::«dispatchEventFctID»(«SCT_EVENT» * «ev»)
			{
				if(«ev» == 0) {
					return false;
				}
				switch(«ev»->name)
				{
					«FOR s : scopes.filter(StatechartScope)»
						«IF !(s instanceof ImportScope)»
							«dispatchStatechartScopeEvents(s, ev)»
						«ENDIF»
					«ENDFOR»
					«FOR s : scopes.filter(Scope)»
						«IF !(s instanceof StatechartScope)»
							«dispatchTimedEvents(s, ev)»
						«ENDIF»
					«ENDFOR»
					default:
						delete «ev»;
						return false;
				}
			}
		'''
	}
	
	protected def CharSequence dispatchStatechartScopeEvents(ExecutionFlow it, StatechartScope s, String ev) {
		'''
		«val events = s.queuedEvents»
		«IF events.size > 0»
			«FOR e : events»
				case «e.eventEnumMemberName»:
			«ENDFOR»
			{
				return «s.namedInstanceAccess»«dispatchEventFctIDbyScope(s)»(«ev»);
			}
		«ENDIF»
		'''
	}
	
	protected def dispatchTimedEvents(ExecutionFlow it, Scope s, String ev) {
		'''
		«val events = s.queuedEvents.toList»
		«FOR e : events»
			case «e.eventEnumMemberName»:
			{
				delete «ev»;
				return «s.instance»[«events.indexOf(e)»] = true;
			}
		«ENDFOR»
		'''
	}
	
	
	def queuedEventDefintions(Scope it) {
		queuedEvents.filter(EventDefinition).toList
	}
	
}