/**
 * Copyright (c) 2020-2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.submodules

import com.google.inject.Inject
import com.google.inject.Provider
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.model.bindings.PropertyChangedNotification
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.codepattern.ScopeTypeDeclarationCode
import com.yakindu.sct.generator.c.extensions.ExpressionsChecker
import com.yakindu.sct.generator.c.types.CTypeSystemAccess
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.CppExpressionsGenerator
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppNamingService
import com.yakindu.sct.generator.cpp.CppObservables
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.providers.ConstructorProvider
import com.yakindu.sct.generator.cpp.templates.ClassDeclaration
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.generator.cpp11.codemodel.EventEnum
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.SubMachine
import com.yakindu.sct.model.sexec.concepts.SubMachine.SubmachineTypeLibrary
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.StatechartScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.ArrayList
import java.util.List

/**
 * @author axel terfloth
 */
class InterfaceFunctions {
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension CppNamingService
	@Inject protected extension SExecExtensions
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension EventCode
	@Inject protected extension ExpressionsChecker
	@Inject protected extension GeneratorPredicate
	@Inject protected extension ShadowEventExtensions
	@Inject protected extension Literals
	@Inject protected extension CppPointers
	@Inject protected extension CppObservables
	@Inject protected extension CppTypes
	@Inject protected extension CppSpecifiers
	@Inject protected extension CppExpressionsGenerator
	@Inject protected extension ConstructorProvider
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension ScopeTypeDeclarationCode
	@Inject protected extension PropertyChangedNotification
	@Inject protected extension SubMachine
	@Inject protected extension SubmachineTypeLibrary
	@Inject protected extension StatemachineClass
	@Inject protected Provider<ClassDeclaration> classDeclProvider
	@Inject protected extension EventEnum

	@Inject protected GeneratorEntry entry

	def interfaceFunctions(ExecutionFlow it) '''
		«FOR scope : getInterfaces»
			«IF scope instanceof InterfaceScope && scope.isNamedScope»
				«module»::«scope.interfaceName»«ifaceReference» «module»::«scope.asGetter»()«_noexcept»
				{
					return «ifaceAsReference»«scope.instance»;
				}
			«ENDIF»
			«generateEvents(scope)»
			«generateVariables(scope)»
			«IF scope.hasOperations && !entry.useStaticOPC»
				«scope.OCB_InterfaceSetterDeclaration(true)»«_noexcept»
				{
					«scope.OCB_Instance» = operationCallback;
				}
			«ENDIF»
			«scope.generateCodeModelMethods»
		«ENDFOR»
		«IF entry.tracingUsed»
			
			void «module»::set«traceObserver»(«scTraceNS»::«traceObserver»<«statesEnumType»>* tracingcallback)«_noexcept» {
				«tracingInstance» = tracingcallback;
			}
			
			«scTraceNS»::«traceObserver»<«module»::«statesEnumType»>* «module»::get«traceObserver»()«_noexcept» {
				return «tracingInstance»;
			}
		«ENDIF»
	'''

	def generateCodeModelMethods(StatechartScope it) ''''''

	def modificationCode(ExecutionFlow it, Scope scope, Property variable) '''
		«IF !variable.const»
			void «module»::«scope.scopedAccess»«variable.asSetter»(«variable.typeSpecifier.targetLanguageName» «variable.name.asEscapedIdentifier»_)«IF !variable.isStringType»«_noexcept»«ENDIF»
			{
				«observerHandler(variable, "unsubscribe")»
				this->«variable.localAccess» = «variable.setterMoveIfNecessary»
				«IF variable.type.appliesSubMachine»
				if(this->«variable.localAccess» != «NULL_LITERAL»)
				{
«««					«IF variable.scope.isNamedScope»«parentMember»->«ENDIF»«it.ctxPointFor(variable).name» = «IF !entry.usePlainPointers»«sharedPtr»«stateMachineClass.subCtx.name»«makeTypeCloser»(«ENDIF»new «stateMachineClass.subCtx.name»(«IF entry.usePlainPointers»this«ELSE»«shareThis»«ENDIF»«IF variable.scope.isNamedScope»->«parentMember»«ENDIF»,«variable.enumerator.asLiteral»)«IF !entry.usePlainPointers»)«ENDIF»;
					this->«variable.localAccess»->«submachineInterfaceSetSubmachineContext.name»(«IF variable.scope.isNamedScope»«parentMember»->«ENDIF»«getSubmachineContextPoint(variable).name»);
				}
«««				«IF !entry.usePlainPointers»
«««				else
«««				{
«««					«IF variable.scope.isNamedScope»«parentMember»->«ENDIF»«it.ctxPointFor(variable).name».reset();
«««				}
«««				«ENDIF»
				«ENDIF»
				«observerHandler(variable, "subscribe")»
				«FOR bu : variable.changedNotifications»
				«bu.implementation.code»;
				«ENDFOR»
			}
			«IF variable.needsAssignMethod»
				«variable.typeSpecifier.targetLanguageName» «module»::«scope.scopedAccess»«variable.assign»(«variable.typeSpecifier.targetLanguageName» «variable.name.asEscapedIdentifier»_)«IF !variable.isStringType»«_noexcept»«ENDIF»
				{
					«variable.asSetter»(«variable.name.asEscapedIdentifier»_);
					return «variable.getterMoveIfNecessary»;
				}
			«ENDIF»
		«ENDIF»
	'''

	def dispatch generateVariables(ExecutionFlow it, StatechartScope scope) '''
		«FOR variable : scope.getProperties»
			«IF variable.isConstString»const «ENDIF»«variable.typeSpecifier.targetLanguageName» «module»::«scope.scopedAccess»«variable.asGetter»()«IF !variable.const && !variable.typeSpecifier.type.name.equals(CTypeSystemAccess.UNIQUE_POINTER)» const«ENDIF»«IF !variable.isStringType»«_noexcept»«ENDIF»
			{
				return «variable.getterMoveIfNecessary»;
			}
			
			«modificationCode(it, scope, variable)»
		«ENDFOR»
	'''

	def setterMoveIfNecessary(Property it) '''
		«IF typeSpecifier.type.name.equals(CTypeSystemAccess.UNIQUE_POINTER)»
			std::move(«name.asEscapedIdentifier»_);
		«ELSE»
			«name.asEscapedIdentifier»_;
		«ENDIF»
	'''

	def getterMoveIfNecessary(Property it) 
	'''«IF typeSpecifier.type.name.equals(CTypeSystemAccess.UNIQUE_POINTER)»
			std::move(«localAccess»)
		«ELSE»
			«localAccess»«ENDIF»'''

	def dispatch generateVariables(ExecutionFlow it, InternalScope scope) '''
		«FOR variable : scope.variableDefinitions»
			«modificationCode(it, scope, variable)»
		«ENDFOR»
	'''

	protected def CharSequence observerHandler(Property variable, String subscription) '''«IF variable.needsShadowEventMapping»
		if(this->«variable.localAccess» != «NULL_LITERAL»)
		{
			«FOR e : variable.shadowEventsByScope.keySet.map[members].flatten.filter(Event)»
				«val outEvent = variable.getShadowEvent(e)»
				«IF outEvent !== null»«IF variable.scope.isNamedScope»«parentMember»->«ENDIF»«outEvent.scope.namedInstanceAccess»«variable.getShadowEvent(e).observer».«subscription»(«variable.name.asEscapedIdentifier»«e.getObserverFromReference»);«ENDIF»
			«ENDFOR»
		}
		«ENDIF»'''

	def private getObserverFromReference(
		Event e) '''->«IF e.scope.isNamedScope»«e.scope.asGetter»()«ifaceAcces»«ENDIF»«e.asObserverGetter»()'''

	def createPublicScope(Scope scope) {
		switch scope {
			InterfaceScope case scope.name === null: if(scope.notEmptyClass) scope.createUnnamedPublicScope
			InterfaceScope case scope.name !== null: if(scope.notEmptyClass) scope.createNamedPublicScope
			InternalScope: createPublicInternalScope(scope)
		}
	}
	
	def dispatch createUnnamedPrivateScope(InterfaceScope scope) '''
		«IF scope.name === null»«scope.declarations.map[getSetAssignPrototypes(scope, it)].flatten.filter[it.key == ClassDeclaration::PRIVATE].map[it.value].join()»«ENDIF»
	'''
	
	def dispatch createUnnamedPrivateScope(Scope scope) '''
		«scope.declarations.map[getSetAssignPrototypes(scope, it)].flatten.filter[it.key == ClassDeclaration::PRIVATE].map[it.value].join()»
	'''
	

	def notEmptyClass(Scope it) {
		!members.nullOrEmpty
	}

	def createPublicInternalScope(InternalScope scope) '''
		«scope.createOCBInterface»
		«scope.declarations.map[getSetAssignPrototypes(scope, it)].flatten.filter[it.key == ClassDeclaration::PUBLIC].map[it.value].join()»
	'''

	def createUnnamedPublicScope(InterfaceScope scope) {
		'''
			«scope.declarations.map[functionPrototypes].join()»
			«scope.declarations.map[getSetAssignPrototypes(scope, it)].flatten.filter[it.key == ClassDeclaration::PUBLIC].map[it.value].join()»
			«scope.createOCBInterface»
		'''
	}

	def createNamedPublicScope(InterfaceScope scope) '''
		«scope.createInterface(classDeclProvider.get).generate»
		
		/*! Returns an instance of the interface class '«scope.interfaceName»'. */
		«scope.interfaceName»«ifaceReference» «scope.asGetter»()«_noexcept»;
		
	'''

	def createInterface(StatechartScope scope, ClassDeclaration scopeDecl) {
		scopeDecl.name(scope.interfaceName).comment('''//! Inner class for «scope.simpleName» interface scope.''').
			constructorDeclaration(newArrayList(scope.parentMemberDeclaration), !scope.containsString)

		scope.declarations.map[functionPrototypes].forEach[scopeDecl.publicMember(it)]
		scope.declarations.map[getSetAssignPrototypes(scope, it)].flatten.forEach[scopeDecl.member(it.key, it.value)]
		scopeDecl.publicMember(scope.publicNamedInterfaceClassMember)
		scopeDecl.member(entry.innerClassVisibility, friendClass(scope))
		scopeDecl.member(entry.innerClassVisibility, protectedInnerClassMembers(scope))
		scopeDecl.member(ClassDeclaration::PRIVATE, '''«scope.parentMemberDeclaration»;''')
		scopeDecl.member(ClassDeclaration::PRIVATE, scope.shadowEvents.map [
			createObserverClass(classDeclProvider.get, scope).generate
		].join())
		scopeDecl.member(ClassDeclaration::PRIVATE, scope.shadowEvents.map[createObserver].join())
		scopeDecl.member(ClassDeclaration::PUBLIC, scope.createOCBInterface)
		scopeDecl.member(ClassDeclaration::PRIVATE, scope.createOCBinstance)
	}

	def createOCBinstance(
		StatechartScope s) '''«IF s.hasOperations && !entry.useStaticOPC»«s.interfaceOCBName»* «s.OCB_Instance»;«ENDIF»'''

	def parentMemberDeclaration(StatechartScope scope) {
		'''«scope.flow.module»* «parentMember»'''
	}

	def friendClass(Scope scope) '''friend class «scope.flow.module»;'''

	def CharSequence publicNamedInterfaceClassMember(Scope scope) ''''''

	def CharSequence protectedInnerClassMembers(Scope scope) '''
		«FOR d : scope.declarations»
			«d.privateFunctionPrototypes»
			«d.scopeTypeDeclMember»
		«ENDFOR»
		«scope.privateFunctionPrototypes»
	'''

	def dispatch privateFunctionPrototypes(Scope it) {
		''''''
	}

	def dispatch privateFunctionPrototypes(Declaration it) {
		''''''
	}

	def dispatch privateFunctionPrototypes(EventDefinition it) {
		''''''
	}

	def createOCBInterface(StatechartScope scope) {
		val scopeDecl = classDeclProvider.get
		if (!scope.hasOperations) {
			return ""
		}
		scopeDecl.name(scope.interfaceOCBName).
			comment('''//! Inner class for «scope.simpleName» interface scope operation callbacks.''')
		if (!entry.useStaticOPC) {
			scopeDecl.destructorDeclaration(true, true)
		}
		scope.operations.forEach [
			scopeDecl.
				publicMember('''«IF entry.useStaticOPC»static«ELSE»virtual«ENDIF» «signature»«IF !entry.useStaticOPC» = 0«ENDIF»;''')
		]

		'''
			«scopeDecl.generate»
			«IF !entry.useStaticOPC»
				
				/*! Set the working instance of the operation callback interface '«scope.interfaceOCBName»'. */
				«scope.OCB_InterfaceSetterDeclaration(false)»«_noexcept»;
			«ENDIF»
		'''
	}

	def dispatch functionPrototypes(EventDefinition it) '''
		«IF direction == Direction::LOCAL»
			/*! Raises the local event '«name»' that is defined in the «scope.scopeDescription». */
			void «asRaiser»(«valueParams»);
			
			/*! Checks if the local event '«name»' that is defined in the «scope.scopeDescription» has been raised. */
			«sc_bool.fqName» «asRaised»() const;
			
			«IF hasValue»
				/*! Gets the value of the local event '«name»' that is defined in the «scope.scopeDescription». */
				«typeSpecifier.targetLanguageName» «asGetter»() const;
				
			«ENDIF»
		«ELSEIF direction == Direction::IN»
			/*! Raises the in event '«name»' that is defined in the «scope.scopeDescription». */
			void «asRaiser»(«valueParams»);
			
		«ELSE»
			«IF useOutEventGetters»
				/*! Checks if the out event '«name»' that is defined in the «scope.scopeDescription» has been raised. */
				«sc_bool.fqName» «asRaised»() const;
				
				«IF hasValue»
					/*! Gets the value of the out event '«name»' that is defined in the «scope.scopeDescription». */
					«typeSpecifier.targetLanguageName» «asGetter»() const;
					
				«ENDIF»
			«ENDIF»
			«IF needsObservable»
				/*! Gets the observable of the out event '«name»' that is defined in the «scope.scopeDescription». */
				«scRxNS»::Observable<«typeSpecifier.targetLanguageName»>* «asObservableGetter»();
				
			«ENDIF»
		«ENDIF»
	'''

	def dispatch functionPrototypes(VariableDefinition it) ''''''

	def dispatch functionPrototypes(Declaration it) ''''''

	def getterPrototype(Scope scope, Property it) '''
		/*! Gets the value of the variable '«name»' that is defined in the «scope.scopeDescription». */
		«IF const»static «ENDIF»«IF isConstString»const «ENDIF»«typeSpecifier.targetLanguageName» «it.asGetter»() «IF !const && !typeSpecifier.type.name.equals(CTypeSystemAccess.UNIQUE_POINTER)»const«ENDIF»«IF !isStringType»«_noexcept»«ENDIF»;
	'''

	def setterPrototype(Scope scope, Property it) '''
		/*! Sets the value of the variable '«name»' that is defined in the «scope.scopeDescription». */
		void «asSetter»(«typeSpecifier.targetLanguageName» «name.asEscapedIdentifier»)«IF !isStringType»«_noexcept»«ENDIF»;
	'''

	def assignmentPrototype(Scope scope, Property it) '''
		/*! Reassigns and returns the (new) value of the variable '«name»' that is defined in the «scope.scopeDescription». */
		«it.typeSpecifier.targetLanguageName» «scope.scopedAccess»«it.assign»(«it.typeSpecifier.targetLanguageName» «it.name.asEscapedIdentifier»_)«IF !it.isStringType»«_noexcept»«ENDIF»;
	'''

	def dispatch List<Pair<String, CharSequence>> getSetAssignPrototypes(Scope scope, Property it) {
		val List<Pair<String, CharSequence>> results = new ArrayList();
		if (!scope.isInternalScope) {
			results.add(Pair.of(ClassDeclaration::PUBLIC, getterPrototype(scope, it)));
		}
		if (!it.const) {
			results.add(Pair.of((scope.isInternalScope || it.readonly ? ClassDeclaration::PRIVATE : ClassDeclaration::PUBLIC), setterPrototype(scope, it)));
		}
		if (it.needsAssignMethod) {			
			results.add(Pair.of(ClassDeclaration::PRIVATE, assignmentPrototype(scope, it)));
		}
		return results;
	}

	def dispatch List<Pair<String, CharSequence>> getSetAssignPrototypes(Scope scope, Declaration it) {
		new ArrayList();
	}
}
