/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.submodules.lifecycle

import com.google.inject.Inject
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.TypesUtil
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.core.submodules.lifecycle.IsActive
import com.yakindu.sct.generator.core.submodules.lifecycle.IsFinal
import com.yakindu.sct.generator.core.submodules.lifecycle.IsStateActive
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.CppExpressionsGenerator
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.FlowCode
import com.yakindu.sct.generator.cpp.eventdriven.EventNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.HaltBehavior
import com.yakindu.sct.model.sexec.concepts.OnInitHook
import com.yakindu.sct.model.sexec.concepts.RunCycleMethod
import com.yakindu.sct.model.sexec.concepts.SubMachine
import com.yakindu.sct.model.sexec.concepts.TriggerWithoutEventMethod
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sct.generator.c.CGeneratorConstants.*
import com.yakindu.sct.model.sexec.concepts.OnUpdateStateHook

/**
 * @author axel terfloth
 */
class LifecycleFunctions implements IsActive, IsStateActive, IsFinal {
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension FlowCode
	@Inject protected extension SExecExtensions
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension INamingService
	@Inject protected extension CppExpressionsGenerator
	@Inject protected extension StateVectorExtensions
	@Inject protected extension Literals
	@Inject protected extension CppSpecifiers
	@Inject protected extension GeneratorPredicate
	@Inject protected extension EventNaming
	@Inject protected extension RunCycleMethod
	@Inject protected extension CppTypes
	@Inject protected extension TriggerWithoutEventMethod
	@Inject protected extension HaltBehavior
	@Inject protected extension OnInitHook	
	@Inject protected extension OnUpdateStateHook	
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension TypesUtil
	@Inject protected extension Documentation
	@Inject protected extension SubMachine
	
	@Inject protected GeneratorEntry entry
	
	def IStatemachineFunctions(ExecutionFlow it) '''
		«IF hasTriggerWithoutEvents»
		/*! «triggerWithoutEvents.documentation» */
		«triggerWithoutEvents.typeSpecifier.targetLanguageName» «triggerWithoutEvents.name»()«_override»;
		«ENDIF»
		«IF hasHalt»
		/*! «halt.documentation» */
		«halt.typeSpecifier.targetLanguageName» «halt.name»();
		«ENDIF»
		«IF hasIsHalted»
		/*! «isHalted.documentation» */
		«isHalted.typeSpecifier.targetLanguageName» «isHalted.name»();
		«ENDIF»
		«IF hasOnInitHook»
		/*! «onInitHook.documentation» */
		«onInitHook.typeSpecifier.targetLanguageName» «onInitHook.name»();
		«ENDIF»
		«IF hasOnUpdateStateHook»
		/*! «onUpdateStateHook.documentation» */
		«onUpdateStateHook.typeSpecifier.targetLanguageName» «onUpdateStateHook.name»();
		«ENDIF»
		«IF hasEventRaised»
		/*! «eventRaised.documentation» */
		«eventRaised.typeSpecifier.targetLanguageName» «eventRaised.name»()«_override»;
		«ENDIF»
		«IF appliesSubMachine»«FOR op : allSubmachineOperations»
		/*! «op.documentation» */
		«op.typeSpecifier.targetLanguageName» «op.name»(«FOR p: op.parameters»const «p.typeSpecifier.targetLanguageName» «p.name»«ENDFOR»)«_override»;
		«ENDFOR»«ENDIF»
		
		/*
		 * Functions inherited from StatemachineInterface
		 */
		«_virtual» void «enterFctID»()«_override»;
		
		«_virtual» void «exitFctID»()«_override»;
		
		«IF hasRunCycleFunctionAsAPI»
		void «runCycleFctID»()«IF !isEventDriven»«_override»«ENDIF»;
		
		«ENDIF»
		/*!
		 * Checks if the state machine is active (until 2.4.1 this method was used for states).
		 * A state machine is active if it has been entered. It is inactive if it has not been entered at all or if it has been exited.
		 */
		«_virtual» «sc_bool.fqName» «isActiveFctID»() const«_noexcept»«_override»;
		
		
		/*!
		* Checks if all active states are final. 
		* If there are no active states then the state machine is considered being inactive. In this case this method returns false.
		*/
		«_virtual» «sc_bool.fqName» «isFinalFctID»() const«_noexcept»«_override»;
	'''
	
	override isActive(ExecutionFlow it) '''
		«sc_bool.fqName» «module»::«isActiveFctID»() const«_noexcept»
		{
			return «FOR i : 0 ..< stateVector.size SEPARATOR '||'»«STATEVECTOR»[«i»] != «null_state»«ENDFOR»;
		}
	'''
	
	override isStateActive(ExecutionFlow it) '''
		«sc_bool.fqName» «module»::«stateActiveFctID»(«statesEnumType» state) const«_noexcept»
		{
			switch (state)
			{
				«FOR s : states»
				case «s.stateName» :
				{
					return «scBoolCast» («
					IF s.leaf
					»«STATEVECTOR»[«s.stateVectorDefine»] == «s.stateName»«
					ELSE
					»«STATEVECTOR»[«s.stateVectorDefine»] >= «s.stateName» && «STATEVECTOR»[«s.stateVectorDefine»] <= «s.subStates.lastOrNull.stateName»«
					ENDIF»);
					break;
				}
				«ENDFOR»
				default:
				{
					/* State is not active*/
					return false;
					break;
				}
			}
		}
	'''	
	
	override isFinal(ExecutionFlow it){
		val finalStateImpactVector = flow.finalStateImpactVector
		// only if the impact vector is completely covered by final states the state machine 
		// can become final
		'''
			«IF !finalStateImpactVector.isCompletelyCovered»
			/* 
			 * Always returns 'false' since this state machine can never become final.
			 */
			«ENDIF»
			«sc_bool.fqName» «module»::«isFinalFctID»() const«_noexcept»
			{
				«IF finalStateImpactVector.isCompletelyCovered»	return «FOR i : 0 ..<finalStateImpactVector.size SEPARATOR ' && '»(«FOR fs : finalStateImpactVector.get(i) SEPARATOR ' || '»stateConfVector[«i»] == «IF fs.stateVector.offset == i»«fs.stateName»«ELSE»«null_state»«ENDIF»«ENDFOR»)«ENDFOR»;
				«ELSE»return false;«ENDIF»
			}
		''' 
	}
	
}