/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.yakindu.base.types.impl.AnnotatedElementImpl
import com.yakindu.sct.generator.c.IncludeProvider
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.PropertyBinder
import com.yakindu.sct.generator.cpp11.files.SCBinding
import com.yakindu.sct.generator.cpp.CppFileNaming

/**
 * 
 * @author axel terfloth
 */
class Cpp11BindingIncludeProvider extends AnnotatedElementImpl implements IncludeProvider {
	
	@Inject protected extension CppFileNaming
	@Inject protected extension PropertyBinder
	@Inject protected SCBinding sc_binding
	
	override getIncludes(ExecutionFlow it, extension IGenArtifactConfigurations artifactConfigs) {
		
		if (appliesBinder) {
			return #[ '''#include "«sc_binding.fileName.relativeTo(module.h)»"''' ]
		}
		return emptyList
	}
	
}