/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.FlowCode
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sexec.TraceStateEntered
import com.yakindu.sct.model.sexec.TraceStateExited
import com.yakindu.sct.model.sexec.UnscheduleTimeEvent
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * 
 * @author axel terfloth - Initial contribution
 */
class Cpp11FlowCode extends FlowCode {
	
	@Inject protected extension CppPointers
	
	@Inject GeneratorEntry entry
	
	override dispatch CharSequence code(ScheduleTimeEvent it) '''
		«stepComment»
		«timerInstance»->«flow.setTimerFctID»(«shareThis», «timeEvent.indexOf», «timeValue.code», «IF timeEvent.periodic»true«ELSE»false«ENDIF»);
	'''

	override dispatch CharSequence code(UnscheduleTimeEvent it) '''
		«stepComment»
		«timerInstance»->«flow.unsetTimerFctID»(«shareThis», «timeEvent.indexOf»);
	'''
	
	override dispatch CharSequence code(TraceStateEntered it) '''
		«IF entry.tracingEnterState»
		if(«flow.tracingInstance» != «NULL_LITERAL») {
			«flow.tracingInstance»->«flow.enterStateTracingFctID»(«it.state.stateName»);
		}
		«ENDIF»
	'''
	
	override dispatch CharSequence code(TraceStateExited it) '''
		«IF entry.tracingExitState»
		if(«flow.tracingInstance» != «NULL_LITERAL») {
			«flow.tracingInstance»->«flow.exitStateTracingFctID»(«it.state.stateName»);
		}
		«ENDIF»
	'''
	
	
}