/**
 * Copyright (c) 2026 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.yakindu.base.types.impl.AnnotatedElementImpl
import com.yakindu.sct.generator.c.IncludeProvider
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.SubMachine

/**
 * 
 * @author axel terfloth
 */
class Cpp11FunctionalIncludeProvider extends AnnotatedElementImpl implements IncludeProvider {
	
	@Inject protected extension SubMachine
	
	override getIncludes(ExecutionFlow it, extension IGenArtifactConfigurations artifactConfigs) {
		
		if (hasReferencedSubmachine) {
			return #[ "#include <functional>" ]
		}
		return emptyList
	}
	
}