/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.providers.ISourceFragment
import com.yakindu.sct.generator.cpp11.codemodel.CodeModel
import com.yakindu.sct.generator.cpp11.codepattern.MethodCode
import com.yakindu.sct.generator.cpp11.codepattern.VariableCode
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.base.types.Declaration
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

/**
 * @author axel terfloth
 */
class Cpp11ProtectedClassMemberProvider implements ISourceFragment {
	
	@Inject protected extension CodeModel
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension GeneratorAssignment
	@Inject protected extension VariableCode
	@Inject protected extension MethodCode
	@Inject protected extension SExecExtensions
	

	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) '''
		
		«FOR e : implementationClass.features.filter[isProtected]»
			
			«e.declarationCode»
		«ENDFOR»
		«««	also generate meta features for exiatig variable definitions
		«FOR e : allVariableDefinitions.map[metaFeatures].flatten.filter[isProtected]»
			
			«e.code»
		«ENDFOR»
	'''	
	
	def protected dispatch code(Property it) {
		variableDeclarationCode
	}
	def protected dispatch code(Operation it) {
		methodDeclarationCode
	}
	
	def protected dispatch code(Declaration it) ''''''
}
