/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.cpp.providers.classdecl.PublicClassMemberProvider
import com.yakindu.sct.generator.cpp11.codemodel.CodeModel
import com.yakindu.sct.generator.cpp11.codepattern.MethodCode
import com.yakindu.sct.generator.cpp11.codepattern.VariableCode
import com.yakindu.sct.model.sexec.ExecutionFlow

/**
 * Use code model for generating state related members and deactivate base class implementations.
 * 
 * @author axel terfloth
 */
class Cpp11PublicClassMemberProvider extends PublicClassMemberProvider {
	
	@Inject protected extension StateEnum
	@Inject protected extension CodeModel
	@Inject protected extension GeneratorAssignment
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension VariableCode
	@Inject protected extension MethodCode
	
	override publicCodeModelMembers(ExecutionFlow it) '''
		«FOR e : publicImplementationClassFeatures.filter[declarationGenerator.exists]»
			«e.declarationCode»
		«ENDFOR»
		
		«FOR e : publicExecutionFlowFeatures.filter[declarationGenerator.exists]»
			«e.declarationCode»
		«ENDFOR»
		
		«««	also generate meta features for exiatig variable definitions
		«FOR e : allVariableDefinitions.map[metaFeatures].flatten.filter[isPublic]»
			
			«e.code»
		«ENDFOR»
		
	'''
	
	
	protected def publicImplementationClassFeatures(ExecutionFlow it) {
		it.implementationClass.features.filter[isPublic]
	}
	
	protected def publicExecutionFlowFeatures(ExecutionFlow it) {
		it.features.filter[isPublic]
	}
	
	override stateDeclarations(ExecutionFlow it) ''''''

	override statesEnumDecl(ExecutionFlow it) ''''''

	def protected dispatch code(Property it) {
		variableDeclarationCode
	}
	def protected dispatch code(Operation it) {
		methodDeclarationCode
	}
	
	def protected dispatch code(Declaration it) ''''''
	
	
}