/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.artifacts

import com.google.inject.Inject
import com.itemis.create.base.generator.core.artifacts.SourceFile
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension

/**
 * Defines the artifact type of a c++ '.h' file and implements the proper interface for integration into the CREATE code generator infrastructure.
 * 
 * @author Axel Terfloth
 */
class HeaderFile extends SourceFile {
	
	@Inject protected GeneratorEntry entry
	@Inject protected extension GenmodelEntriesExtension
	
	override fileExtension() { "h" }
		
	override content() {
		'''
			#pragma once
			
			«entry.licenseText»
			«compilationUnit.declarationCode»
			
		'''
	}
}
